#!/bin/bash

CUR_PATH=$(cd `dirname $0`;pwd)
cd ${CUR_PATH}
. ./controller.inc
. ./check_memory.sh
. ./check_io.sh
. ./check_iops.sh
. ./check_cpu.sh
. ./check_disk.sh
. ./check_partition_volume.sh
. ./check_os_version.sh
. ./check_install.sh
. ./check_user.sh
. ./check_service_status.sh
. ./check_network_config.sh
. ./check_node_network_segment.sh
. ./check_feature.sh

################################################################################
# name    :    main
# describe:    main function of check environment about MDSP
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : main
################################################################################
#step1: check Partition

function main()
{
    #the variable count the fail time of check step
    typeset -i fail_num=0
    # generate conf to param
    flag_file=/root/EasySuite/888/conf/config.properties

    #CPU arch
    cpu_arch_log='/opt/install_check/check_cpu_arch.log'
    cat ${cpu_arch_log}

    #step0: 主节点和扩容节点 都执行网络检查
    check_network_config
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[successfully] Checking network config successfully !"
    fi
    echo "custom_check_init_network_config"

    # 特性检查
    echo "custom_check_feature_check"
    check_feature
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[successfully] Checking check_feature successfully !"
    fi
    echo "custom_check_feature_check"

    #step10: 在主节点上检查业务节点的状态是否正常
    echo "custom_check_service_status"
    check_service_status
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[successfully] Checking service status successfully !"
    fi
    echo "custom_check_service_status"

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        echo 'check_env_sh_flag=1' >> ${flag_file}
        return 1
    else
        echo "===========================CHECKING ENVIRONMENT SUCCESSFULLY========================"
        echo "===================================================================================="
        echo 'check_env_sh_flag=0' >> ${flag_file}
        return 0
    fi
}

# os_pwd_root,
IFS=$'\n'
echo "es_input: os_pwd_root"
read -sr os_root_user_pwd

#execute main function
main "$@"
