#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_fi_mmvalue
# Description : check the fi_mmvalue is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_fi_mmvalue()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    fi_login_ip=$(cat /opt/huawei/Bigdata/om-server/om/inst/conf/oms-config.ini | grep ws_float_ip= | awk -F'=' '{print $2}')
    if [[ x${fi_login_ip} == x ]];then
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: Can't find fi login ip."
        echo "-----------------------------------------------------"
        echo "[Solution]: Check whether the FusionInsight management plane is normal."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi
    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    fi
    result=$(echo ${fi_login_ip} | grep ":")
    if [[ "$result" != "" ]]
    then
        fi_login_ip="["${fi_login_ip}"]"
    fi
    curl -i -k  https://${fi_login_ip}:20009/cas/login 2>/dev/null | grep 'HTTP.*200'
    if [[ $? != 0 ]];then
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: Cannot login FusionInsight management."
        echo "-----------------------------------------------------"
        echo "[Solution]: Check whether the FusionInsight management plane is normal."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi
    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    fi

    escape_password=""
    # 对密码每个字符添加\进程转义，防止密码中的特殊字符对于shell语句有特殊作用
    IFS_OLD=$IFS
    IFS=$'\n'
    for index in $(seq 1 $((${#lld_fi_access_mmvalue})));
    do
        ch=$(echo ${lld_fi_access_mmvalue} | cut -c"${index}")
        escape_password=${escape_password}"\\"${ch};
    done
    IFS=$IFS_OLD
    echo ${escape_password} | xargs -i curl -ik --user admin:{} https://${fi_login_ip}:28443/web/ 2>/dev/null | grep 'HTTP.*200'
    if [[ $? != 0 ]];then
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: FusionInsight management login password error."
        echo "-----------------------------------------------------"
        echo "[Solution]: Enter the correct password for logging in to the FusionInsight management plane on the configuration page."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    fi

    echo " "
    echo "-----------------------------------------------------"
    echo "[successfully]Check status and password of FusionInsight successfully, please continue."
    echo "-----------------------------------------------------"
    echo " "

    return 0
}
