#!/bin/bash

##########################################
# 初始化日志(处理日志绕接)
# @param
#   level --日志级别
#   msg   --日志信息
# @env
#   LOG_PATH --日志文件存放路径
#   LOG_FILE --日志文件名
##########################################
function LOG()
{
    msg="${2}"
    if [ "${1}" == "ERROR" ]
    then
        level="ERROR"
    elif [ "${1}" == "WARN" ]
    then
        level="WARN"
    else
        level="INFO"
    fi
    if [ ! -d "${LOG_PATH}" ]
    then
        mkdir -p ${LOG_PATH}
        chown ossadm:ossgroup ${LOG_PATH}
    fi
    if [ -f "${LOG_FILE}" ];then
        log_size=$(ls -l "${LOG_FILE}" | awk '{print $5}')
        if [ "${log_size}" -gt 5000000 ]
        then
            su - ossadm -c "echo \"The log_file is :${LOG_FILE}\">>${LOG_FILE}"
            su - ossadm -c "echo \"The log_size is :${log_size}\">>${LOG_FILE}"
            Date=$(date '+%Y-%m-%d %H:%M:%S')
            su - ossadm -c "echo \"${Date}|Zip the log.\" >>${LOG_FILE}"
            LOG_FILEbak="${LOG_FILE}.1"
            su - ossadm -c "cp -p ${LOG_FILE} ${LOG_FILEbak}"
            su - ossadm -c "echo 'Zip the log' >${LOG_FILE}"
        fi
    fi
    su - ossadm -c "echo \"[$(date '+%Y-%m-%d %H:%M:%S')] [${level}] $2\" >> ${LOG_FILE}"
}

##########################################
# 初始化任务管理目录
# @param
#   taskid --任务ID
##########################################
function init_taskmgr()
{
    task_id="${1}"
    task_mgr_path="/opt/upgrade/easysuite_upgrade/taskmgr/"
    if [ ! -d "${task_mgr_path}" ]
    then
        mkdir -p ${task_mgr_path}
    fi
    chown :ossgroup /opt/upgrade/easysuite_upgrade
    chown ossadm:ossgroup /opt/upgrade/easysuite_upgrade/taskmgr/
    if [ -f "/opt/upgrade/easysuite_upgrade/taskmgr/${task_id}/task.log" ]
    then
        su - ossadm -c "rm -f ${task_mgr_path}/${task_id}/task.progress ${task_mgr_path}/${task_id}/task.status 2>/dev/null"
    else
        su - ossadm -c "rm -rf ${task_mgr_path}/${task_id} 2>/dev/null;mkdir -p ${task_mgr_path}/${task_id}"
        su - ossadm -c "touch ${task_mgr_path}/${task_id}/task.log"
    fi
    su - ossadm -c "echo Progress=0 >${task_mgr_path}/${task_id}/task.progress"
    su - ossadm -c "echo Status=running >${task_mgr_path}/${task_id}/task.status"
}

function upgrade_log()
{
    log_level="${1}"
    log_info="${2}"
    LOG "${log_level}" "${log_info}"
    su - ossadm -c "echo \"[$(date '+%Y-%m-%d %H:%M:%S')] [$$] [${log_level}] ${log_info}\">>/opt/upgrade/easysuite_upgrade/taskmgr/${task_id}/task.log"
}

##################################################
# 异常退出
##################################################
function do_exit()
{
    local do_task_id="${1}"
    su - ossadm -c "echo Status=fail >/opt/upgrade/easysuite_upgrade/taskmgr/${do_task_id}/task.status"
    su - ossadm -c "echo Progress=100 >/opt/upgrade/easysuite_upgrade/taskmgr/${do_task_id}/task.progress"
}

##################################################
# 检查进程信息
##################################################
function check_script_process()
{
    local script_name="${1}"
    # 第一次不记录日志
    ps -ef | fgrep "${script_name}" | grep -v grep >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        sleep 1
        date >>${LOG_FILE} 2>&1
        ps -ef | fgrep "${script_name}" | grep -v grep >>${LOG_FILE} 2>&1 && return 0
        date >>${LOG_FILE} 2>&1
        ps -ef | fgrep "${script_name}" | grep -v grep >>${LOG_FILE} 2>&1 || return 1
    fi
    return 0
}