#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_service_status
# Description : check service status is OK.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_service_status()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    # tenant product_name
    product_name=$(cat /opt/oss/manager/etc/sysconf/nodelists.json | grep -E 'FabricInsight|CampusInsight|SOP' | head -n 1| awk -F "[:]" '/assignedToTenancy/{print$2}' | awk -F "[\"\"]" '{print$2}')
    su - ossadm -c "source /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusnodes -tenant ${product_name}" | grep -E 'PARTIAL|UNKNOWN|FAULT|NOT EXIST|STOPPING|STARTING|STOPPED|FAILURE'
    if [[ $? -eq 0 ]]
    then
        ((error_fail_num=error_fail_num+1))
    fi

    # tenant manager
    su - ossadm -c "source /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusnodes -tenant manager" | grep -E 'PARTIAL|UNKNOWN|FAULT|NOT EXIST|STOPPING|STARTING|STOPPED|FAILURE'
    if [[ $? -eq 0 ]]
    then
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: There are services exception occurs on the CloudSOP management plane."
        echo "-----------------------------------------------------"
        echo "[Solution]: Restore the environment first. Perform subsequent operations only when the environment is normal."
        echo "-----------------------------------------------------"
        echo " "
		echo " " >&2
        return 1
		#failed
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The service status is right, please continue."
        echo "-----------------------------------------------------"
        echo " "
        return 0
    fi
}
