#!/bin/bash

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/expansion_rollback.log"

OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 660 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi
    Level="INFO"
    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    echo $1 | grep -i "INFO" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}


Main()
{
    MACHINE_MACHINE_ACCOUNT=$2
    echo ${MACHINE_MACHINE_ACCOUNT}
    if [ -f ${logFile} ];then
        chmod 660 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi
    expansion_dir="/opt/expansion"
    expansion_backup_dir="${expansion_dir}_backup"
    # 防呆，结果文件
    if [ ! -f "${expansion_backup_dir}/expansion_rollback_product.log" ]
    then
        touch "${expansion_backup_dir}/expansion_rollback_product.log"
    fi
    if [[ -f "${expansion_backup_dir}/rollback_product.pyc" ]]
    then
        ROLLBACK_FILE=rollback_product.pyc
    else
        if [[ -f "${expansion_backup_dir}/rollback_product.py" ]]
        then
            ROLLBACK_FILE=rollback_product.py
        else
            OperateLog "ERROR" "Can not find rollback_product.py/pyc"
            return 1
        fi
    fi
    OperateLog "INFO" "Start to execute rollback_product.py"
    su - ${MACHINE_MACHINE_ACCOUNT} -c ". /opt/oss/manager/bin/engr_profile.sh; python ${expansion_backup_dir}/${ROLLBACK_FILE} ${expansion_backup_dir}"
    ret_code=$?
    if [[ ${ret_code} -ne 0 ]];then
        OperateLog "ERROR" "Rollback operation failed"
        return ${ret_code}
    fi
    OperateLog "INFO"  "The rollback deployment has been executed successfully."
    return ${ret_code}
}

Main $*
echo $? > "${expansion_backup_dir}/expansion_rollback_product.log"
exit $?
