#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalIP.sh
# Version:Data          : 
# Description           : modifty /etc/sysconfig/network/ifcfg-X
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"

#get absolute path
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
#import common variable..
. ../common/error_code.inc
. ../common/common.inc
cd - >/dev/null 2>&1


# Name        : fn_clean_tmp_file
# Description : Clear temporary files and directories in the installation process
function fn_remove_tmp_file()
{
    [ -d "${TMP_CONFIG_PATH}" ] && rm -rf "${TMP_CONFIG_PATH}"/tmp*
    return 0
}


# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value
function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi
    
    if [ "${RETCODE}" = 0 ]
    then
        echo "`date` `hostname` `whoami` setLocalIP.sh;Successful;Set IP Successfully." >> /var/log/localmessages
        echo "Set IP Successfully. "
    else
        echo "`date` `hostname` `whoami` setLocalIP.sh;Failed;Set IP Failed." >> /var/log/localmessages
        echo "Set IP Failed."
    fi    
    chmod 640 /var/log/localmessages

    return 0
}


# Name        : fn_check_or_modify_ifcfg
# Description : check ifcfg-eth-X
# Parameters  : $1 ifcfg-eth-X
function fn_check_or_modify_ifcfg()
{
    local ifcfg_file=$1

    grep -w 'IPADDR' "${ifcfg_file}" > /dev/null 2>&1 || echo "IPADDR=''" >> "${ifcfg_file}" 
    grep -w 'NETWORK' "${ifcfg_file}" > /dev/null 2>&1 || echo "NETWORK=''" >> "${ifcfg_file}" 
    grep -w 'BOOTPROTO' "${ifcfg_file}" > /dev/null 2>&1 || echo "BOOTPROTO='static'" >> "${ifcfg_file}" 

    return 0
}


# Name        : fn_get_config
# Description : get the config from osmu
# Parameters  : $1 properties file
function fn_get_config()
{
    local TMP_CONFIG_FILE=$1
    local BOND_NAME
    local NIC_DEVICE
    local NIC_DEVICE_BACKUP
    local IPADDR
    local NETMASK
    local IP_HOSTNAME
    cat $TMP_CONFIG_FILE
    BOND_NAME=`fn_get_value "${TMP_CONFIG_FILE}" "BOND_NIC_NAME"`
    NIC_DEVICE=`fn_get_value "${TMP_CONFIG_FILE}" "NIC_DEVICE"`
    NIC_DEVICE_BACKUP=`fn_get_value "${TMP_CONFIG_FILE}" "NIC_DEVICE_BACKUP"`
    IPADDR=`fn_get_value "${TMP_CONFIG_FILE}" "IPADDR"`
    NETMASK=`fn_get_value "${TMP_CONFIG_FILE}" "NETMASK"`
    IP_HOSTNAME=`fn_get_value "${TMP_CONFIG_FILE}" "IP_HOSTNAME"`

    
    if [ -z "${NIC_DEVICE}" ] ||  [ -z "${IPADDR}" ] || [ -z "${NETMASK}" ]
    then
        PRINT_LOG "FATAL" "The param NIC_DEVICE<${NIC_DEVICE}>,IPADDR<${IPADDR}>,NETMASK<${NETMASK}>could not found!"
        return "${ERROR_PARAM}"
    fi

    fn_validate_ipv6 "${IPADDR}" || return $?
    fn_validate_ipv6_prefix "${NETMASK}" || return $?
    
    if [ ! -z $BOND_NAME ]
    then
        eval $2="${BOND_NAME}"
        if [ ! -z $NIC_DEVICE_BACKUP ]
        then
            eval $4="${NIC_DEVICE_BACKUP}"
        else
            PRINT_LOG "FATAL" "The param NIC_DEVICE_BACKUP could not found! There must be two nic device to create a bond nic"
            return "${ERROR_PARAM}"
        fi
    fi

    eval $3="${NIC_DEVICE}"
    eval $5="${IPADDR}"
    eval $6="${NETMASK}"
    eval $7="${IP_HOSTNAME}"

    return 0
}

# Name        : fn_modify_ifcfg_file
# Description : modify ifcfg-eth-X
# Parameters  : $1 ifcfg-eth-X
# Parameter   : $2 network card mac address
# Parameter   : $3 pci bus id
function fn_modify_ifcfg_file()
{
    local ifcfg_file=$1
    local ipaddr=$2
    local netmask=$3
    local network=$4
    local card_name=$5
    local bus_pci=$6
    local num=$7
    # 修改ifcfg-eth-X文件。
    sed -i -e "/^BOOTPROTO=/c BOOTPROTO='static'" \
          -e "/^STARTMODE=/c STARTMODE='auto'" \
          -e "/^DHCPV6C=/c DHCPV6C=no" \
          -e "/^NETWORK=/c NETWORK='${network}'" \
          -e "/^NAME=/c NAME='${card_name}'" \
          -e "/^_nm_name=/c _nm_name='bus-pci-${bus_pci}'" "${ifcfg_file}" > "${TMP_CONTENT_FILE}" 2>&1
    if [ $? -ne 0 ]
    then
        PRINT_LOG  "FATAL" "Set ${ifcfg_file} configuration file ...failed"
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        return ${ERR_EXECSYS}
    fi
    if [ ${num} -eq -1 ]
    then
        echo "IPADDR=${ipaddr}/${netmask}" >> "${IFCFG_FILE}"
    else
        echo "IPADDR_${num}=${ipaddr}/${netmask}" >> "${IFCFG_FILE}"
    fi
    
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
    PRINT_LOG  "INFO" "Set ${ifcfg_file} configuration file ...OK"
    
    return 0 
}

# Name        : get_max_ipaddr_num
# Description : get next use IPADDR_num
# Parameters  : $1 ifcfg-eth-X
function get_next_ipaddr_num()
{
    local ifcfg_file=$1
    grep "IPADDR=" ${ifcfg_file} > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
      return -1
    fi
    local num=`cat ${ifcfg_file} | grep "IPADDR_" | awk -F"IPADDR_" '{print $2}' | awk -F"="  '{print $1}' | awk 'BEGIN {max = 0} {if ($1+0 >= max+0) {max= $1+1} } END {print max}'`
    return ${num}
}


function fn_main()
{
    local REF_BOND_NAME
    local REF_NIC_DEVICE
    local REF_NIC_DEVICE_BACKUP
    local REF_IPADDR
    local REF_NETMASK
    local REF_NETWORK
    local REF_BROADCAST
    local REF_DB_INTERFACES_ADDR
    
    local REF_OS_TYPE
    local network_card_name
    local NETWORK_CARD_NAME
    local HW_ADDR
    local BUS_PCI
    local IFCFG_FILE
    
    PRINT_LOG "INFO" "bash $0 $1"
    if [ $# -lt 1 ]
    then
        PRINT_LOG "FATAL" "Usage: $0 <config file>"
        PRINT_LOG "FATAL" "e.g:      $0 /opt/osmu/script/properties/sample.properties"
        fn_check_status "${ERROR_PARAM}"
    fi
    
    CONFIG_FILE=`echo "$1" | sed 's/\\\/\//g'`
    
    sed -i "s/[[:space:]]*$//g" "${CONFIG_FILE}"
    fn_check_config_file "${CONFIG_FILE}" || return $?

    fn_get_config "${TMP_CONFIG_FILE}" REF_BOND_NAME REF_NIC_DEVICE REF_NIC_DEVICE_BACKUP REF_IPADDR REF_NETMASK REF_IP_HOSTNAME

    if [ $? -ne 0 ]
    then
        return "${ERROR_PARAM}"
    fi

    ## 取得网卡总线号
    BUS_PCI="`ethtool -i ${REF_NIC_DEVICE} 2> /dev/null |grep 'bus-info' | cut -d ' ' -f 2`"
    ## 取得总线号对应网卡的说明 
    [ -z "${BUS_PCI}" ] || network_card_name=`lspci -v 2> /dev/null | awk -v 'RS=' '/'"${BUS_PCI#*:}"'/ {print $0}' | egrep -i "\<Subsystem: "`
    NETWORK_CARD_NAME=${network_card_name#*Subsystem:}
    ## 取得MAC地址
    HW_ADDR="`ifconfig ${REF_NIC_DEVICE} |awk -F 'ddr ' '/\<HWaddr / {print $2}' | tr [A-Z] [a-z] | xargs`"
    CFG_DIR="/etc/sysconfig/network"
    CFG_FILE_NAME="ifcfg-${REF_NIC_DEVICE}"
    IFCFG_FILE="${CFG_DIR}/${CFG_FILE_NAME}"
    IFCFG_BAK_DIR="/etc/sysconfig/network/OLD_IFCFG_BAK"
    
    [ -f "${IFCFG_BAK_DIR}" ] || mkdir -p "${IFCFG_BAK_DIR}"


    ## 检查网卡对应的配置文件是否存在
    if [ ! -f "${IFCFG_FILE}" ]
    then
        PRINT_LOG "WARN" "${IFCFG_FILE} does not exist"
        echo "BOOTPROTO='static'" >> "${IFCFG_FILE}"
        echo "DEVICE='${REF_NIC_DEVICE}'" >> "${IFCFG_FILE}"
        echo "IPADDR=${REF_IPADDR}/${REF_NETMASK}" >> "${IFCFG_FILE}"
        echo "STARTMODE='auto'" >> "${IFCFG_FILE}"
        echo "NETWORK='${REF_NETWORK}'" >> "${IFCFG_FILE}"
        PRINT_LOG "INFO" "Generate ${IFCFG_FILE} file success"
    else
        #备份一份原始配置文件
        [ -f "${IFCFG_BAK_DIR}/${CFG_FILE_NAME}.bak" ] && cp -a "${IFCFG_FILE}" "${IFCFG_BAK_DIR}/${CFG_FILE_NAME}.$$.bak"
        cp -a "${IFCFG_FILE}" "${IFCFG_BAK_DIR}/${CFG_FILE_NAME}.bak"
        
        #查询IP下一个可用的编号
        get_next_ipaddr_num "${IFCFG_FILE}"
        #修改配置文件
        fn_modify_ifcfg_file "${IFCFG_FILE}" "${REF_IPADDR}" "${REF_NETMASK}" "${REF_NETWORK}" "${NETWORK_CARD_NAME}" "${BUS_PCI}" $?
        if [ $? -ne 0 ]
        then
            mv -f "${IFCFG_BAK_DIR}/${CFG_FILE_NAME}.bak" "${IFCFG_FILE}"
            return ${ERR_EXECSYS}
        fi
    fi

    #修改完成后重新启动网卡使配置文件生效。
    rcnetwork restart "${REF_NIC_DEVICE}" > "${TMP_CONTENT_FILE}" 2>&1
    if [ $? -ne 0 ]
    then
        PRINT_LOG "WARN" "Excute<rcnetwork restart \"${REF_NIC_DEVICE}\"> ...failure"
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        return ${ERR_EXECSYS}
    fi
    PRINT_LOG "WARN" "Excute<rcnetwork restart \"${REF_NIC_DEVICE}\"> ...OK"
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"

    local old_ip=`ifconfig "${REF_NIC_DEVICE}" | grep "inet6 addr:" | grep "Global" | awk -F"inet6 addr:" '{print $2}' | awk '{print $1}' | xargs`
    
    local hosts_file="/etc/hosts"
    local tmp_hosts_file="/etc/hosts-maintain-tools-bak"
    if [ -n "${REF_IP_HOSTNAME}" ]
    then
        if [ -f "${hosts_file}" ]
        then
            cp -a "${hosts_file}" "${tmp_hosts_file}"
            if [ -n "${old_ip}" ]
            then
                grep -w "^${old_ip}" "${hosts_file}" > /dev/null 2>&1
                if [ $? -eq 0 ]
                then
                    sed -i "s#^${old_ip}.*#${REF_IPADDR} ${REF_IP_HOSTNAME}#g" "${hosts_file}" > "${TMP_CONTENT_FILE}" 2>&1
                    if [ $? -ne 0 ]
                    then
                        PRINT_LOG "FATAL" "Excute cmd<sed -i \"s#^${old_ip}.*#${REF_IPADDR} ${REF_IP_HOSTNAME}#g\" \"${hosts_file}\"> to modifty ${hosts_file} failure"
                        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                        return 1
                    fi
                    PRINT_LOG "INFO" "Excute sed cmd to modifty ${hosts_file} success"
                else
                    echo "${REF_IPADDR} ${REF_IP_HOSTNAME}" >> "${hosts_file}"
                    PRINT_LOG "INFO" "Excute cmd<echo \"${REF_IPADDR} ${REF_IP_HOSTNAME}\"> to modifty ${hosts_file} success"
                fi
             else
                 echo "${REF_IPADDR} ${REF_IP_HOSTNAME}" >> "${hosts_file}"
                 PRINT_LOG "INFO" "Excute cmd<echo \"${REF_IPADDR} ${REF_IP_HOSTNAME}\"> to modifty ${hosts_file} success"
             fi
        else
            PRINT_LOG "WARN" "file ${hosts_file} is not exist"
        fi
     else
        PRINT_LOG "INFO" "REF_IP_HOSTNAME<${REF_IP_HOSTNAME}> is empty, no need to change ${hosts_file} file"
     fi
    
    return ${SUCCESS_CODE};
}

#=======================================================================
fn_main "$@"
ret=$?
fn_write_operation_log ${ret}
FUNC_CLEAN_TMP_FILE
exit ${ret}
#=======================================================================
