#!/bin/bash

USER=`id | awk -F'[()]' '{print $2}'`
FILENAME=`basename $0`
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
CUR_PATH=/opt/install
ADD_NTP_FILE="add_ntp.pyc"
NTP_IP_NUM="0"
NTP_IP_ACTIVE=""
NTP_MODE_ACTIVE=""
NTP_AGORITHM_ACTIVE=""
NTP_INDEX_ACTIVE=""
NTP_KEY_ACTIVE=""
NTP_IP_STANDBY=""
NTP_MODE_STANDBY=""
NTP_AGORITHM_STANDBY=""
NTP_INDEX_STANDBY=""
NTP_KEY_STANDBY=""
LOG_FILE=/var/log/tools/add_ntp/add_ntp.log

[ ! -d "/var/log/tools/add_ntp/" ] && mkdir -p /var/log/tools/add_ntp/
if [ ! -f "${LOG_FILE}" ]
then
    touch ${LOG_FILE}
    chmod 600 ${LOGFILE}
fi

log()
{
    local msg="$*";
    printf "[`date '+%Y-%m-%d %H:%M:%S'`] ${msg} \n";
    printf "[`date '+%Y-%m-%d %H:%M:%S'`] ${msg} \n" >> ${LOG_FILE};
}

#check root user
CheckUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}


getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100   
   ">/opt/install/check_add_ntp_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255
   ">/opt/install/check_add_ntp_result.sh
   fi
   echo "rm -rf /opt/install/check_add_ntp_result.sh
   ">>/opt/install/check_add_ntp_result.sh
   chmod 750 /opt/install/check_add_ntp_result.sh
}

CheckPara()
{
    INPUT_ARGS=$*
    for i in {1..43}
    do
        [ "$1" = "" ] && continue
        [ "$2" = "" ] && continue
        [ ${1} = "-ntpnum" ] && { NTP_IP_NUM=$2; shift 2; continue; }
        [ ${1} = "-activentpmode" ] && { NTP_MODE_ACTIVE=$2; shift 2; continue; }
        [ ${1} = "-activentpindex" ] && { NTP_INDEX_ACTIVE=$2; shift 2; continue; }
        [ ${1} = "-activentpkeypasswd" ] && { NTP_KEY_ACTIVE=$2; shift 2; continue; }
        [ ${1} = "-activentp" ] && { NTP_IP_ACTIVE=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode1" ] && { NTP_MODE_STANDBY_1=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex1" ] && { NTP_INDEX_STANDBY_1=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey1passwd" ] && { NTP_KEY_STANDBY_1=$2; shift 2; continue; }
        [ ${1} = "-standbyntp1" ] && { NTP_IP_STANDBY_1=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode2" ] && { NTP_MODE_STANDBY_2=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex2" ] && { NTP_INDEX_STANDBY_2=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey2passwd" ] && { NTP_KEY_STANDBY_2=$2; shift 2; continue; }
        [ ${1} = "-standbyntp2" ] && { NTP_IP_STANDBY_2=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode3" ] && { NTP_MODE_STANDBY_3=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex3" ] && { NTP_INDEX_STANDBY_3=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey3passwd" ] && { NTP_KEY_STANDBY_3=$2; shift 2; continue; }
        [ ${1} = "-standbyntp3" ] && { NTP_IP_STANDBY_3=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode4" ] && { NTP_MODE_STANDBY_4=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex4" ] && { NTP_INDEX_STANDBY_4=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey4passwd" ] && { NTP_KEY_STANDBY_4=$2; shift 2; continue; }
        [ ${1} = "-standbyntp4" ] && { NTP_IP_STANDBY_4=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode5" ] && { NTP_MODE_STANDBY_5=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex5" ] && { NTP_INDEX_STANDBY_5=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey5passwd" ] && { NTP_KEY_STANDBY_5=$2; shift 2; continue; }
        [ ${1} = "-standbyntp5" ] && { NTP_IP_STANDBY_5=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode6" ] && { NTP_MODE_STANDBY_6=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex6" ] && { NTP_INDEX_STANDBY_6=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey6passwd" ] && { NTP_KEY_STANDBY_6=$2; shift 2; continue; }
        [ ${1} = "-standbyntp6" ] && { NTP_IP_STANDBY_6=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode7" ] && { NTP_MODE_STANDBY_7=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex7" ] && { NTP_INDEX_STANDBY_7=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey7passwd" ] && { NTP_KEY_STANDBY_7=$2; shift 2; continue; }
        [ ${1} = "-standbyntp7" ] && { NTP_IP_STANDBY_7=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode8" ] && { NTP_MODE_STANDBY_8=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex8" ] && { NTP_INDEX_STANDBY_8=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey8passwd" ] && { NTP_KEY_STANDBY_8=$2; shift 2; continue; }
        [ ${1} = "-standbyntp8" ] && { NTP_IP_STANDBY_8=$2; shift 2; continue; }
        [ ${1} = "-standbyntpmode9" ] && { NTP_MODE_STANDBY_9=$2; shift 2; continue; }
        [ ${1} = "-standbyntpindex9" ] && { NTP_INDEX_STANDBY_9=$2; shift 2; continue; }
        [ ${1} = "-standbyntpkey9passwd" ] && { NTP_KEY_STANDBY_9=$2; shift 2; continue; }
        [ ${1} = "-standbyntp9" ] && { NTP_IP_STANDBY_9=$2; shift 2; continue; }
    done
    return 0
}

set_file()
{
    if [ -f "${CUR_PATH}/add_ntp.pyc" ]
    then
        ADD_NTP_FILE=add_ntp.pyc
    else
        if [ -f "${CUR_PATH}/add_ntp.py" ]
        then
            ADD_NTP_FILE=add_ntp.py
        else
            log "Error: Can not find add ntp file"
            return 1
        fi
    fi
    chown ossadm: ${CUR_PATH}/add_ntp.py*
}

add_active_ntp()
{
    if [ -z "${NTP_IP_ACTIVE}" ]
    then
        log "Error: Active NTP server IP does not exist."
        return 1
    fi
    if [ "${NTP_MODE_ACTIVE}" == "NTP_V3" ]
    then
        su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python ${CUR_PATH}/${ADD_NTP_FILE} \"${NTP_IP_ACTIVE}\" \"true\" \"default\""
        if [ $? -ne 0 ]
        then
            log "Error: Failed to add active ntp server"
            return 1
        fi
    else
        su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python ${CUR_PATH}/${ADD_NTP_FILE} \"${NTP_IP_ACTIVE}\" \"true\" \"encrypt\" \"M\" \"${NTP_INDEX_ACTIVE}\" \"${NTP_KEY_ACTIVE}\""
        if [ $? -ne 0 ]
        then
            log "Error: Failed to add active ntp server"
            return 1
        fi
    fi
    return 0
}

add_standby_ntp()
{
    i=1
    while [ ${i} -lt ${NTP_IP_NUM} ]
    do
        NTP_MODE_STANDBY=NTP_MODE_STANDBY_${i}
        NTP_INDEX_STANDBY=NTP_INDEX_STANDBY_${i}
        NTP_KEY_STANDBY=NTP_KEY_STANDBY_${i}
        NTP_IP_STANDBY=NTP_IP_STANDBY_${i}
        if [ "${!NTP_MODE_STANDBY}" == "NTP_V3" ]
        then
            su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python ${CUR_PATH}/${ADD_NTP_FILE} \"${!NTP_IP_STANDBY}\" \"false\" \"default\""
            if [ $? -ne 0 ]
            then
                log "Error: Failed to add standby ntp server"
                return 1
            fi
        else
            su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python ${CUR_PATH}/${ADD_NTP_FILE} \"${!NTP_IP_STANDBY}\" \"false\" \"encrypt\" \"M\" \"${!NTP_INDEX_STANDBY}\" \"${!NTP_KEY_STANDBY}\""
            if [ $? -ne 0 ]
            then
                log "Error: Failed to add standby ntp server"
                return 1
            fi
        fi
        i=`expr $i + 1`
    done
    return 0
}

#Add NTP Server
addNTP()
{
    if [ "${NTP_IP_NUM}" = "0" ]
    then
        log "No need to configure NTP."
        return 0
    elif [ "${NTP_IP_NUM}" -eq "1" ]
    then
        set_file || return 1
        add_active_ntp || return 1
    elif [ "${NTP_IP_NUM}" -ge "2" ]
    then
        set_file || return 1
        add_active_ntp || return 1
        add_standby_ntp || return 1
    fi
    return 0
}

Main()
{
    CheckUser
    if [ $? -ne 0 ]
    then
        return 1
    fi
    [ -f "/opt/install/check_add_ntp_result.sh" ] && rm -rf /opt/install/check_add_ntp_result.sh
    #get all install parameter
    CheckPara $*
    if [ $? -ne 0 ]
    then
        log "Error: Input parameters are incorrect."
        return 1
    fi
    #addNTP
    addNTP $*
    if [ $? -ne 0 ]
    then
        log "Error: Failed to add ntp server"
        return 1
    fi

}

Main $*
result=$?
getcheckResult $result
if [ "${result}" -eq 0 ]
then
    logger -t ${USER} -p local0.info "${FILENAME};Successful;${OPERIP:-127.0.0.1};Excute ${FILENAME}"
else
    logger -t ${USER} -p local0.err "${FILENAME};Failed;${OPERIP:-127.0.0.1};Excute ${FILENAME}"
fi
exit $result