#!/bin/bash

isinstallarray=$1
arrayip=$2
arrayupd=""
arrayunewpd=""

arraylunname="LUN00"
arrayhostgroupname="HOSTGROUP001"
arrayhostname="HOST001"
mappingview="MAPPINGVIEW001"

diskdomainname="DISKDOMAIN00"
storagepoolname="STORAGEPOOL00"
lungroupname="LUNGROUP001"

lunmaxsizeGB=1500
dismorecmdlist=""

#��־�ļ�
installlog=""

GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}

OperateLog()
{
    if [ -f "$curPath/../../tools/OperationLog/businessoperatelog.sh" ]
    then
        $curPath/../../tools/OperationLog/businessoperatelog.sh "$1" "$2"
        return 0
    fi
}

getTime()
{
    MONTH=`date +%m`
    DAY=`date +%d`
    HOUR=`date +%H`
    MIN=`date +%M`
    SEC=`date +%S`
    Time="$MONTH""$DAY""$HOUR""$MIN""$SEC"
    echo "$Time"
}

IsIP()
{
    ipresult=""
    ipaddr=$1
    echo $ipaddr | grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" | grep -v grep > /dev/null 2>&1
    if [ $? -ne 0 ] 
    then
      echo $ipresult
      return 0
    fi

    ipaddr1=`echo $ipaddr | awk -F "." '{print $1}'`
    ipaddr2=`echo $ipaddr | awk -F "." '{print $2}'` 
    ipaddr3=`echo $ipaddr | awk -F "." '{print $3}'` 
    ipaddr4=`echo $ipaddr | awk -F "." '{print $4}'` 
    for num in $ipaddr1 $ipaddr2 $ipaddr3 $ipaddr4 
    do
        if [ $num -gt 255 ] || [ $num -lt 0 ]
            then 
            echo $ipresult
            return 0 
        fi 
    done 

    if [ $ipaddr1 -eq 0 ] 
    then 
        echo $ipresult
        return 0 
    fi
    
    echo $ipaddr
    return 0 
}

IsDisableMore()
{
    local checkCMD="$1"
    if [ "$checkCMD" = "" ]
    then
        echo "N"
        return 0
    fi
    
    local lineNO="1"
    while :
    do
        local oneCMD=`echo "$dismorecmdlist" | awk -F":" '{print $'"$lineNO"'}'`
        if [ "$oneCMD" = "" ]
        then
            break
        elif [ "$oneCMD" = "$checkCMD" ]
        then
            echo "Y"
            return 0
        fi
        
        lineNO=`expr $lineNO + 1`
    done
    
    echo "N"
    return 0
    
}

RunToArray()
{
    local runCMD="$1"
    beginCurTime=`getTime`
    echo "begin:$beginCurTime:$runCMD" >> "$installlog"
    logfile="$2"
    runResult="0"

    isDisableMore=`IsDisableMore "$runCMD"`

    if [ $# -eq 3 ] 
    then
        expect autorun.sh "$arrayip" "$arrayunewpd" "$runCMD" "$arrayupd" "$isDisableMore" >${logfile}
        runResult=$?
        cat ${logfile} >>${arrayCommand}
    else
        expect autorun.sh "$arrayip" "$arrayunewpd" "$runCMD" "$arrayupd" "$isDisableMore" >>${logfile}
        runResult=$?
    fi
    
    dos2unix $logfile $logfile > /dev/null 2>&1

    if [ $runResult -ne 0 ]
    then
        echo "Failed to install the disk array, possibly because the IP address, user name, or password is incorrect."
        OperateLog "Configure array failed; \"$runCMD\" failed." "error"
        exit $runResult
    fi

    sleep 3
    
    endCurTime=`getTime`
    echo "end:$endCurTime" >> "$installlog"
    return 0
}

GetValueFromArray()
{
    arrayCmd="$1"
    valueStr="$2"
    local lineNO="$3"
    arrayInfo="$install_tmp/arrayInfo.log"
    RunToArray "$arrayCmd" "$arrayInfo" "replaceOutput"
    valueResult=`cat $arrayInfo  | grep "$valueStr" | awk '{print $'"$lineNO"'}'`
    echo "$valueResult"
    return 0
}

Initarray()
{
    clearCmd="$1"
    checkString="$2"
    RunToArray "$clearCmd" "$installlog"
    sleepTime=0
    while [ $sleepTime -lt 300 ]
    do
        sleep 30
        echo "............................................."
        sleepTime=`expr $sleepTime + 30`
    done
    
    check_info="$install_tmp/checkdast"
    while :
    do
        if ping -c 3 $arrayip >>${installlog}
        then
            RunToArray "" "$check_info" "replaceOutput"
            grep "$checkString" $check_info > /dev/null 2>&1
            if [ $? -ne 0 ]
            then
                break
            fi
            echo -e "The disk array has not been completed started. \nThe system will automatically retry 10 seconds later.Please wait..."
            sleep 10
            continue
        fi
        sleep 30
    done
    sleep 30
}

Init()
{
    GetWorkPath
    curTime=`getTime`
    
    install_tmp="/var/ICMR/arraydisk"
    if [ ! -d "$install_tmp" ]
    then
        mkdir -p $install_tmp > /dev/null 2>&1
    fi

    myname=`basename $0`
    installlog="$install_tmp/${myname}.${curTime}.log"
    disks_info="$install_tmp/alldiskinfo.log"
    dismorecmdlist="show lun general:show disk general:show storage_pool general:show disk_domain general"
    
    arrayCommand="$install_tmp/arrayCommand.log"
    if [ -f ${arrayCommand} ]
    then
        rm -f ${arrayCommand}
    fi
}

CheckAndGetInput()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        OperateLog "CheckUser failed;Execute AutoSetup5500.sh failed." "error"
        return 1
    fi

    pkg_path=`cd $curPath/../../../;pwd`
    install_type=`cat /var/ICMR/sles10sp4_sign_file.inf | grep 'installtype=1'`
    if [ $? -eq 0 ]
    then
        UltraPath_pkg="$pkg_path/UltraPath-*.rpm"
        UltraPath_dir="$pkg_path/OSSICMR/thirdParty/S2600/"
        UltraPath_install=`rpm -qa | grep UltraPath`
        if [ $? -eq 0 ]
        then
            echo " "
            
        elif [ ! -f $UltraPath_pkg ]
        then
            echo "The Ultrapath installation package does not exist. "
            echo "Please save the Ultrapath package to the directory where the ICMR package is stored and decompress it."
            exit 1
        elif [ ! -d $UltraPath_dir ]
        then
            mkdir -p $UltraPath_dir
            cp $UltraPath_pkg $UltraPath_dir
        else
            cp $UltraPath_pkg $UltraPath_dir
        fi
    fi

    userfile="$curPath/../../conf/silent/silent_info.cfg"
  
    if [ $# -eq 2 ]
    then
        while [ 1 ]
        do
            echo ""
            echo "============= Excute this script at: `date` ============="

            echo "-------------------------------------------------------------------------------"
            echo "---------------       Configure OceanStor 5500 DiskArray     ---------------"
            echo "------------------    !!WARNING!! !!WARNING!! !!WARNING!!    ------------------"
            echo "------------   This script will destroy  the data of the array!!    -----------"
            echo "-------------------------------------------------------------------------------"

            if [ "$isinstallarray" = "" ]
            then
                continue
            elif [ "$isinstallarray" = "y" -o "$isinstallarray" = "Y" ]
            then
                break
            elif [ "$isinstallarray" = "n" -o "$isinstallarray" = "N" ]
            then
                echo "You choose not to configure array,the command exit!"
                return 0
            else
                continue
            fi
        done

        while [ "$arrayip" = "" ]
        do
            if [ "$arrayip" = "" ]
            then
                echo "============================================="
                echo "Invalid IP address."
                echo "============================================="
            fi
        done

        read arrayupd
        arrayunewpd="$arrayupd"
        
    elif [ $# -eq 3 -a "$1" = "-silent" ]
    then
        arrayip="$2"
          arrayip=`IsIP $arrayip`
        if [ "$arrayip" = "" ]
        then
            echo "Invalid IP address."
            return 1
        fi
        if [ -f $userfile ]
        then
            isinstallarray="y"
            arrayupd="$3"
        fi
    else
        echo "The number of parameters or parameter types error."
        return 1
    fi
    return 0
}

GetGBSize()
{
    freeSize="$1"
    finalSize=""
    echo $freeSize | grep "GB$" | grep -v grep > /dev/null 2>&1
    if [ $? -eq 0 ]
    then
        finalSize=`echo "$freeSize" | awk -F"GB" '{print $1}' | awk -F"." '{print $1}'`
    else
        tbSzie=`echo "$freeSize" | awk -F"TB" '{print $1}' | awk -F"." '{print $1}'`
        gbSzie=`echo "$freeSize" | awk -F"TB" '{print $1}' | awk -F"." '{print $2}'`
        gbSzie=`echo ${gbSzie:0:3}`
        finalSize=`expr $tbSzie \* 1024 + $gbSzie \* 1`
    fi
    finalSize=`expr $finalSize - 5`
    echo ${finalSize}
    return 0
}

CreateLUN()
{
    local tmpstoragepoolname="$1"
    local tmplunname="$2"
    local tmplungroupID="$3"

    local tmpspfreeSize=`GetValueFromArray "show storage_pool general" "$tmpstoragepoolname" "7"`

    local tmplunSize=`GetGBSize $tmpspfreeSize`
    if [ $tmplunSize -gt $lunmaxsizeGB ]
    then
        tmplunSize=$lunmaxsizeGB
    fi
    

    if [ $tmplunSize -le 0 ]
    then
        echo "-1"
        return 0
    fi 

    local tmpspID=`GetValueFromArray "show storage_pool general" "$tmpstoragepoolname" "1"`
    
    RunToArray "create lun name=$tmplunname pool_id=$tmpspID capacity=${tmplunSize}GB owner_controller=0A" "$installlog"

    local tmplunID=`GetValueFromArray "show lun general" "$tmplunname" "1"`

    RunToArray "add lun_group lun lun_group_id=$tmplungroupID lun_id_list=$tmplunID" "$installlog"
    
    echo $tmplunID
    return 0
}

CreateDDSP()
{
    local tmpDDName="$1"
    local tmpSPName="$2"

    RunToArray "create disk_domain name=$tmpDDName disk_number=all disk_type=SAS" "$installlog"

    diskdomainID=`GetValueFromArray "show disk_domain general" "$tmpDDName" "1"`
    raidlevel="RAID10"
    ddfreeSize=`GetValueFromArray "show disk_domain available_capacity disk_domain_id=$diskdomainID raid_level=$raidlevel" "$tmpDDName" "4"`

    spSize=`GetGBSize $ddfreeSize`
    RunToArray "create storage_pool name=$tmpSPName disk_type=SAS capacity=${spSize}GB raid_level=$raidlevel disk_domain_id=$diskdomainID" "$installlog"
    return 0
}



ConfigureArray()
{
    if [ "$isinstallarray" = "n" ] || [ "$isinstallarray" = "N" ]
    then
        OperateLog "Choose not to configure array;Execute AutoSetup5500.sh failed." "information"
        exit 1
    fi
    
    echo -e "\n==========================================="
    echo -e "Installing the disk array..."

    type_info="$install_tmp/typeinfo.log"
    RunToArray "" "$type_info" "replaceOutput"
    cat $type_info | egrep "5500 V3|5500 V5" | grep -v grep > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "It is not OceanStor 5500 V3 or V5."
        OperateLog "Check array type failed;Execute AutoSetup5500.sh failed." "error"
        exit 1
    fi

    RunToArray "show system management_ip" "$type_info" "replaceOutput"
    controller_num=`cat $type_info | grep -i "IPv4 Address" | wc -l`
    controller_num=`echo $controller_num`
    if [ $controller_num -eq 2 ]
    then
        controller_a=`cat $type_info | grep -i "IPv4 Address" | sed -n "1p" | awk -F":" '{print $2}'`
        controller_a=`echo $controller_a`
        controller_b=`cat $type_info | grep -i "IPv4 Address" | sed -n "2p" | awk -F":" '{print $2}'`
        controller_b=`echo $controller_b`
        if [ $arrayip = $controller_a ]
        then
            controller_name="0A"
        else
            controller_name="0B"
        fi
        RunToArray "show controller general controller=$controller_name" "$type_info" "replaceOutput"
        cat $type_info | grep -i "Slave" > /dev/null 2>&1
        if [ $? -eq 0 ]
        then
            echo "The IP address is not belong to the master controller,please use the master controller IP to connect."
            OperateLog "Check array controller role failed;Execute AutoSetup5500.sh failed." "error"
            exit 1
        fi
    fi

    RunToArray "show disk general" "$disks_info" "replaceOutput"

    disknum=`cat ${disks_info} | grep Online | grep SAS | wc -l`
    if [ $disknum -lt 12 ]
    then
        echo "The number of idle disks is less than 12,the command exit!"
        OperateLog "The disk array does not have sufficient idle disks." "information"
        exit 1
    fi

    arrayresult=0
    modifyFstab
    Initarray "change user_mode current_mode user_mode=developer" "minisystem"

    RunToArray "show disk general" "${disks_info}_init" "replaceOutput"
    disknum=`cat ${disks_info}_init | grep Online | grep SAS | grep Free | wc -l`
    if [ $disknum -lt 12 ]
    then
        echo "The number of idle disks is less than 12,the command exit!"
        OperateLog "After init:The disk array does not have sufficient idle disks." "information"
        exit 1
    fi    

    CreateDDSP "${diskdomainname}1" "${storagepoolname}1"
    RunToArray "create lun_group name=$lungroupname" "$installlog"

    local lungroupID=`GetValueFromArray "show lun_group general" "$lungroupname" "1"`

    local lunID=`CreateLUN "${storagepoolname}1" "${arraylunname}1" "$lungroupID"`

    RunToArray "create host name=$arrayhostname operating_system=Linux" "$installlog"

    hostID=`GetValueFromArray "show host general" "$arrayhostname" "1"`

    for initiator in `GetValueFromArray "show initiator initiator_type=FC" "Online" "1"`
    do
        RunToArray "add host initiator host_id=$hostID initiator_type=FC wwn=$initiator" "$installlog"
        break
    done

    RunToArray "create host_group name=$arrayhostgroupname host_id_list=$hostID" "$installlog"
    hostgroupID=`GetValueFromArray "show host_group general" "$arrayhostgroupname" "1"`

    RunToArray "create mapping_view name=$mappingview lun_group_id=$lungroupID host_group_id=$hostgroupID" "$installlog"
    arrayresult=$?
    if [ $arrayresult -eq 0 ]
    then
        echo "Disk array installed successfully."
    fi
    return $arrayresult    
}

modifyFstab()
{
    fstabFile="/etc/fstab"
    isHa=1
    uname |grep Linux >/dev/null 2>&1
    if [ $? -eq 0 ];then
        if [ -f $fstabFile ];then
            cp $fstabFile /etc/fstab.bak
        else
            echo "$fstabFile does not exist"
        fi

        inf_file="/var/ICMR/sles10sp4_sign_file.inf"
        if [ -f $inf_file ];then
            cat $inf_file | grep installtype=1 >/dev/null 2>&1
            if [ $? -eq 0 ];then 
                isHa=0
            fi
        else
            echo "$inf_file does not exist"
            isHa=2
        fi
        if [ $isHa -eq 0 -o $isHa -eq 2 ];then
            cat $fstabFile | grep -v /dev/sdb1 | grep -v /dev/sdb2 > /etc/fstab.temp
            mv /etc/fstab.temp $fstabFile
            chmod 640 $fstabFile
        fi
    fi
}

Main()
{
    Init

    CheckAndGetInput $*
    if [ $? -ne 0 ]
    then
      OperateLog "Check failed;Execute AutoSetup5500.sh failed." "error"
      exit 1
    fi

    ConfigureArray
    if [ $? -ne 0 ]
    then
      arrayupd=""
      arrayunewpd=""
      OperateLog "ConfigureArray failed;Execute AutoSetup5500.sh failed." "error"
      exit 1
    fi
   
    OperateLog "ConfigureArray successful;Execute AutoSetup5500.sh successful." "information"  
    exit 0
}

Main $*
