#!/bin/bash

createCheckFile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/opt/expansion/check_restart_apps_result.sh
 
   chmod 550 /opt/expansion/check_restart_apps_result.sh
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100   
   ">/opt/expansion/check_restart_apps_result.sh
   else
       exit_code=$1
       echo "Error: expand.py exit with code ${exit_code}"
       echo "#!/bin/bash
echo  RESULT:255
   ">/opt/expansion/check_restart_apps_result.sh
   fi
   echo "rm -rf /opt/expansion/check_restart_apps_result.sh
   ">>/opt/expansion/check_restart_apps_result.sh
   chmod 550 /opt/expansion/check_restart_apps_result.sh
}

Main()
{
    createCheckFile
    
    if [ -f "/opt/expansion/get_app_ip.pyc" ]
    then
        EXPAND_FILE=get_app_ip.pyc
    else
        if [ -f "/opt/expansion/get_app_ip.py" ]
        then
            EXPAND_FILE=get_app_ip.py
        else
            echo "Error: Can not find get_app_ip file"
            return 1
        fi
    fi
    chown ossadm:ossgroup /opt/expansion/${EXPAND_FILE}
    chown ossadm:ossgroup /opt/expansion
    touch /opt/expansion/app_ip.txt
    chown ossadm:ossgroup /opt/expansion/app_ip.txt
    su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; python /opt/expansion/${EXPAND_FILE}"
    if [ $? -ne 0 ]
    then
        echo "Error: Failed to get app node ip."
        return 1
    fi
    app_ip=`cat /opt/expansion/app_ip.txt`
    echo ${app_ip}
    cmd_stop="ssh ossadm@""${app_ip}"" \"/opt/oss/manager/agent/bin/ipmc_adm -cmd stopnodes -tenant NCE\""
    echo $cmd_stop
    su - ossadm -c "${cmd_stop}"
    if [ $? -ne 0 ]
    then
        echo "Error: Failed to execute stop nodes."
        return 1
    fi
    cmd_start="ssh ossadm@""${app_ip}"" \"/opt/oss/manager/agent/bin/ipmc_adm -cmd startnodes -tenant NCE\""
    echo $cmd_start
    su - ossadm -c "${cmd_start}"
    if [ $? -ne 0 ]
    then
        echo "Error: Failed to execute start nodes."
        return 1
    fi
    rm /opt/expansion/app_ip.txt
}

Main $*
getcheckResult $?
exit $?


