#!/bin/bash
USER=$(whoami)
MODULE_NAME="$(basename $0)"

if [ "$#" = "3" -a "$2" = "-path" ]
then
    installDir=$3
elif [ "$#" = "4" -a "$3" = "-path" ]
then
    installDir=$4
else
    installDir=/opt/install
fi

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

#log
OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}

GetServerInfo()
{
    BackServerIP=$1
    Pw=$2
    serverInfo="
        {
        \"SFTPServerIPAddress\": \"${BackServerIP}\",
        \"username\": \"ftpuser\",
        \"password\": \"${Pw}\",
        \"backuppath\": \"backup\"
        }"
}

InitDefaultBackServer()
{
    Pw=`cat $installDir/input.json | grep FTP_PASSWD | awk -F : '{print $2}' | awk -F \" '{print $2}'`
    backupServerJsonHead="{
    \"backupmode\": \"SFTP\",
    \"NFS\": {
        \"nfsbackuppath\": \"/export/home/backup\"
    },
    \"SFTPList\": ["
    separator=","
    backupServerJsonEnd="]}"
    GetServerInfo $BackServerIP_01 $Pw
    defaultBackServerStr="${backupServerJsonHead}${serverInfo}"
    if [ ! $BackServerIP_02 ]
    then
        echo "${defaultBackServerStr}${backupServerJsonEnd}">$installDir/defaultBackServer.json
    else
        GetServerInfo $BackServerIP_02 $Pw
        defaultBackServerStr="${defaultBackServerStr}${separator}${serverInfo}${backupServerJsonEnd}"
        echo "${defaultBackServerStr}">$installDir/defaultBackServer.json
    fi

    chmod 750 $installDir/defaultBackServer.json
    # 设置备份服务器时,如果/opt/backup/ftpboot/backup 不为空则删除
    [ -d /opt/backup/ftpboot/backup ] && [ ! "`ls -A /opt/backup/ftpboot/backup`" = "" ] && rm -rf /opt/backup/ftpboot/backup/*
    chown ossadm:ossgroup $installDir/defaultBackServer.json
    return 0
}

function check_ipv6()
{
    [[ $1 =~ ^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$ ]]
}

CheckIP()
{
    # 检查ipv4
    echo $1 | grep "^[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}$" >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        # 检查ipv6
        check_ipv6 $1
        if [ $? -ne 0 ]
        then
            echo -e "the $1 is invalid ip\n\t"
            echo "RESULT:255"
            return 1
        fi
    fi
    BackServerIP_01=$1

    # 检查ipv4
    echo $2 | grep "^[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}$" >/dev/null 2>&1
    check_ipv4_res=$?
    # 检查ipv6
    check_ipv6 $2
    check_ipv6_res=$?
    if [ ${check_ipv4_res} -ne 0 -a ${check_ipv6_res} -ne 0 ]
    then
        return 0
    fi
    BackServerIP_02=$2
}

Main()
{
    CheckIP $1 $2
    if [ $? -ne 0 ]
    then
      echo "Input is error,please check." 1>&2
      return 1
    fi

    InitDefaultBackServer

    echo "Config default backup server."
    cat ${installDir}/defaultBackServer.json &>> /tmp/${MODULE_NAME}.log
    sed -i '/password/d' /tmp/${MODULE_NAME}.log 2>/dev/null
    bash /opt/oss/manager/tools/backuprestore/setglobalpara.sh -input ${installDir}/defaultBackServer.json &>> /tmp/${MODULE_NAME}.log
    local res=$?
    if [ ${res} -ne 0 ];then
        echo "Failed to config backup server, Result code ${res}." 1>&2
        OperateLog "error" "Error: Failed to config backup server, Result code ${res}."
        logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed to config backup server, Result code ${res}."
        echo "RESULT:255"
        return 1
    fi
    echo "Succeeded to config backup server, Result code ${res}."
    OperateLog "info" "INFO: Succeeded to config backup server, Result code ${res}."
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: Succeeded to config backup server, Result code ${res}."
    echo "RESULT:100"
    return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    RESULT=$?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
    RESULT=$?
fi

if [ ${RESULT} -eq 0 ]
then
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: Succeeded to config backup server."
else
    logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed to config backup server."
fi
exit ${RESULT}
