#!/bin/bash
. ./read_pw.sh
. /etc/profile
#install dir
installDir=/opt/install
#uniep package
uniepPackage="iMasterNCE.*\OMP_linux-.*64.zip"
MODULE_NAME="$(basename $0)"
USER=$(whoami)

#create action.json check file
createCheckFile()
{
    echo "#!/bin/bash" >/opt/install/check_manager_result.sh
    echo "echo  RESULT:1" >>/opt/install/check_manager_result.sh
    chmod 750 /opt/install/check_manager_result.sh
}

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/install/check_manager_result.sh
   ">/opt/install/check_manager_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/install/check_manager_result.sh
   ">/opt/install/check_manager_result.sh
   fi
   chmod 750 /opt/install/check_manager_result.sh > /dev/null 2>&1
   return $1
}


create_pwuser()
{
    (echo $all_os_default_passwd; echo $product_pwd_sopuser; echo $product_pwd_ossadm; echo $product_pwd_ossuser; echo $product_pwd_redis_dbuser; echo $product_pwd_zenith_sys; echo $product_pwd_admin_web_control;) | bash ${installDir}/create_pwfile.sh ${installDir} $uniepPkg_path
}

#checkInputParam
CheckInstallPara()
{
   for i in {1..15}
    do
        [[ ${1#-} == "ip" ]] && { ip=$2;shift 2;continue; }
        [[ ${1#-} == "version" ]] && { version=$2;shift 2;continue; }
        [[ ${1#-} == "accessip" ]] && { accessip=$2;shift 2;continue; }
        [[ ${1#-} == "accessip2" ]] && { accessip2=$2;shift 2;continue; }
        [[ ${1#-} == "lang" ]] && { lang=$2;shift 2;continue; }
        [[ ${1#-} == "mode" ]] && { mode=$2;shift 2;continue; }
        [[ ${1#-} == "azname" ]] && { azname=$2;shift 2;continue; }
        [[ ${1#-} == "scalesize" ]] && { scalesize=$2;shift 2;continue; }
        [[ ${1#-} == "pkglist" ]] && { pkglist=$2;shift 2;continue; }
        [[ ${1#-} == "APP_ARBI_ON" ]] && { APP_ARBI_ON=$2;shift 2;continue; }
        [[ ${1#-} == "DEPLOY_MODE" ]] && { DEPLOY_MODE=$2;shift 2;continue; }
        [[ ${1#-} == "networkinfo" ]] && { networkinfo="${2}";shift 2;continue; }
        [[ ${1#-} == "deployexpired" ]] && { deployexpired="${2}";shift 2;continue; }
        [[ ${1#-} == "drnetworktype" ]] && { drnetworktype="${2}";shift 2;continue; }
    done
    
    ExecParam=
    if [ "X${ip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -ip ${ip}`
    fi

    if [ "X${accessip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessip ${accessip}`
    fi

    if [ "X${accessip2}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessip2 ${accessip2}`
    fi
    
    if [ "X${lang}" != "X" ];then
        ExecParam=`echo ${ExecParam} -lang ${lang}`
    fi
    
    if [ "X${mode}" != "X" ];then
        ExecParam=`echo ${ExecParam} -mode ${mode}`
    fi
    
    if [ "X${azname}" != "X" ];then
        ExecParam=`echo ${ExecParam} -azname ${azname}`
    fi
    
    if [ "X${scalesize}" != "X" ];then
        ExecParam=`echo ${ExecParam} -scalesize ${scalesize}`
    fi
    
    if [ "X${networkinfo}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -networkinfo ${networkinfo})
    fi
    
    if [ "X${DEPLOY_MODE}" != "X" ];then
        ExecParam=$(echo ${ExecParam} -DEPLOY_MODE ${DEPLOY_MODE})
    fi
    
    if [ "X${APP_ARBI_ON}" != "X" ];then
        ExecParam=$(echo ${ExecParam} -APP_ARBI_ON ${APP_ARBI_ON})
    fi
    
    if [ "X${pkglist}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -pkglist ${pkglist})
    else
        ExecParam=$(echo ${ExecParam} -pkglist pkglist_default.conf)
    fi
    
    if [ "X${deployexpired}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -deployexpired ${deployexpired})
    else
        ExecParam=$(echo ${ExecParam} -deployexpired 30)
    fi
    
    get_install_pw
    
    return 0
}

#初始化包
checkPackage()
{
    #==========================管理包===============================
    #检查包
    uniepPkg=`ls $installDir | grep "^${uniepPackage}$" | grep -v grep`
    if [ "$uniepPkg" = "" ]
    then
        OperateLog "error" "Error: the uniep package is not exists, rendering the install_uniep.sh script failed."
        return 1
    fi
    chmod -R 750 $installDir  && cd $installDir > /dev/null 2>&1
    if [ -d $installDir/${uniepPkg%%.*} ];then
        rm -rf $installDir/${uniepPkg%%.*}
    fi
    uniepPkg_path=$installDir/${uniepPkg%%.*}
    unzip -oq $uniepPkg -d  $uniepPkg_path
    return 0
}

uninstall()
{
    #卸载管理面
    if [ -f "/opt/oss/manager/agent/tools/shscript/uninstall.sh" ]
    then
        cd /opt/oss/manager/agent/tools/shscript && bash uninstall.sh -f >>${logFile} 2>&1
    fi
}

update_crl()
{
    crl_file_build="/opt/install/HuaweiRootCAsipCRLs.crl"
    crl_file_release="/opt/install/HuaweiRootCAsipCRLs_Release.crl"
    if [ ! -d "/tmp/oss" ]
    then
        mkdir "/tmp/oss"
        chown ossadm:ossgroup "/tmp/oss"
    fi

    if [ -f ${crl_file_build} ]
    then
        cp ${crl_file_build} "/tmp/oss"
        chmod 400 "/tmp/oss/HuaweiRootCAsipCRLs.crl"
        chown ossadm:ossgroup "/tmp/oss/HuaweiRootCAsipCRLs.crl"
        curPath="/opt/oss/manager/apps/UniEPLiteService/tools/crlTools"
        excute_ord="huaweicrltool.sh -cmd replaceCrl -all -type BUILD_SIGN"
        su - ossadm -c "cd ${curPath} && echo 'y' | bash ${excute_ord}"
        RESULT=$?
        if [ ${RESULT} -ne 0 ]
        then
            OperateLog "error" "Error:update build crl failed"
        else
            OperateLog "info" "update build crl successfully"
        fi
    fi
    
    if [ -f ${crl_file_release} ]
    then
        cp ${crl_file_release} "/tmp/oss"
        chmod 400 "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl"
        chown ossadm:ossgroup "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl"
        if [ -f "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl" ]
        then
            mv /tmp/oss/HuaweiRootCAsipCRLs_Release.crl /tmp/oss/cs_g2_crls.crl
        fi
        curPath="/opt/oss/manager/apps/UniEPLiteService/tools/crlTools"
        excute_ord="huaweicrltool.sh -cmd replaceCrl -all -type RELEASE_SIGN"
        su - ossadm -c "cd ${curPath} && echo 'y' | bash ${excute_ord}"
        RESULT=$?
        if [ ${RESULT} -ne 0 ]
        then
            OperateLog "error" "Error:update release crl failed"
        else
            OperateLog "info" "update release crl successfully"
        fi
    fi
}

deal_empty_nodes()
{
    if [ "X${drnetworktype}" != "X" ];then
        bash ${curPath}/deal_empty_nodes.sh ${installDir} ${drnetworktype}
        return 0
    fi
    bash ${curPath}/deal_empty_nodes.sh ${installDir} "IPv4"
}

#installUniep
Install()
{
    checkPackage
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to check the package, rendering the install_uniep.sh script failed."
        return 1
    fi
    
    create_pwuser
    deal_empty_nodes
    #========================安装管理面=================================
    chmod -R 750 $installDir > /dev/null 2>&1
    cd $installDir/${uniepPkg%%.*} 

    
    echo "bash install.sh $ExecParam -pwfile $installDir/pwuser.json"
    bash install.sh ${ExecParam} -pwfile "${installDir}"/pwuser.json
    res=$?
    # 一定要删除密码文件
    rm -rf "${installDir}"/pwuser.json
    
    chmod 640 logs/bootstrap.log > /dev/null 2>&1
    chmod 640 logs/addmgmtnic.log > /dev/null 2>&1
    if [ $res -ne 0 ]
    then
        OperateLog "error" "Error: Failed to install management plane, rendering the install_uniep.sh script failed."
        return 1
    fi
    OperateLog "info" "Management plane installed successfully."
    #管理面安装成功了以后,调取平台命令替换签名文件
    update_crl

    if [ "X${version}" != "X" ];then
        bash change_version.sh ${version}
        if [ $? -ne 0 ]
        then
            OperateLog "error" "Error: Change OMP version failed."
        fi
    fi

    return 0
}

Main()
{
    createCheckFile
    #get all install parameter
    CheckInstallPara $*
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Input parameters are incorrect, rendering the install.sh script failed."
        return 1
    fi
    
    uninstall
    
    #install
    Install
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to init the software package, rendering the install_uniep.sh script failed."
        return 1
    fi
    
    return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    getcheckResult $?
    RESULT=$?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
    RESULT=$?
fi

if [ ${RESULT} -eq 0 ]
then
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: Succeeded to install manager."
else
    logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed to install manager."
fi
exit ${RESULT}
