#!/bin/bash
. /etc/profile
MODULE_NAME="$(basename $0)"
#install dir
installDir=/opt/install
#icmr sofrware package
icmrPackage="U2000.*\ICMR_linux_.*64.zip"
#uniep package
uniep="U2000.*\OMP_linux_.*64"
#EasySuite package
EasySuitePackage="U2000.*\EasySuite"
#U2000 package
u2000Package="U2000.*"


#####################################
#2018.2.13规避平台问题
#当前提供规避方案：检测IO占用小于85%的时候，再执行扫描包的任务，保证任务执行成功
#超时2min退出
#####################################
waitIOHealth()
{
    for ((i=0; i<12; i++))
    do
        [ ! -f iostat ] && { return 0; }
        #wait all io util < 85
        isok=`iostat -d -x 1 2 | sed -n '/Device:/,$p' | sed '/Device:/d' | sed '/^$/d'  | awk '{print $NF}'  | awk '{print $NF}'  | awk 'BEGIN {isok = 0}
        {
            for (j = 1; j <= NF; ++j) {
                if ($j > 85) isok = 1
            }
        }
        END {print isok}'`
        [ "$isok" == 0 ] && { echo "io stat is ok"; break; }
        echo "io util is more than 85%, sleep 10 seconds..."
        sleep 10
    done
}

createCheckFile()
{
    echo "#!/bin/bash" >/opt/install/check_scan_result.sh
    echo "echo  RESULT:1" >>/opt/install/check_scan_result.sh
    chmod 750 /opt/install/check_scan_result.sh
}

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/install/check_scan_result.sh
   ">/opt/install/check_scan_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/install/check_scan_result.sh
   ">/opt/install/check_scan_result.sh
   fi
   chmod 750 /opt/install/check_scan_result.sh > /dev/null 2>&1
}

#install product
Install()
{ 
    chmod -R 750 $installDir > /dev/null 2>&1
    #先清除旧的
    rm -rf /opt/oss/manager/var/tmp/*
    rm -rf /opt/pub/software/services/*
    #拷贝产品包
    u2000PackageList=`ls $installDir | grep "^$u2000Package" | egrep -v "grep|${uniep}|${icmrPackage}|${EasySuitePackage}"`
    if [ "$u2000PackageList" != "" ]
    then
        for package in ${u2000PackageList}
        do
        {
            cp -rf $installDir/${package} /opt/oss/manager/var/tmp
        }
        done
    fi
    chown -R ossadm:ossgroup /opt/oss/manager/var/tmp
    
    
    #####################################
    #2018.2.13规避平台问题
    #当前提供规避方案：检测IO占用小于85%的时候，再执行扫描包的任务，保证任务执行成功
    #####################################
    waitIOHealth

    #scan silent
    cd /opt/oss/manager/tools/deployapp && bash scanpackage.sh
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Install product: scan silent failed, rendering the install_uniep.sh script failed."
        return 1
    fi
    
    return 0
}

Main()
{
    createCheckFile
    #install
    Install
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to init the software package, rendering the install_uniep.sh script failed."
        return 1
    fi
    
   return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    getcheckResult $?
    exit $?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
fi