#!/bin/bash
installDir=/opt/install

echo "es_input: product_pwd_ftpuser"
read product_pwd_ftpuser
if [ "X${product_pwd_ftpuser}" == "X" ];then
    OperateLog "error" "Error: get ftpuser passwd failed."
    exit 1
fi
product_pwd_ftpuser_encrypt=`{ echo -e "${product_pwd_ftpuser}\n${product_pwd_ftpuser}" ;}|su - ossadm -c "bash /opt/oss/manager/agent/bin/osskey -cmd encryptpasswd" 2>/dev/null`


echo "es_input: product_pwd_admin_web_service"
read product_pwd_admin_web_service
if [ "X${product_pwd_admin_web_service}" == "X" ];then
    OperateLog "error" "Error: get admin_web_service passwd failed."
    exit 1
fi
admin_webservice_passwd_encrypt=`{ echo -e "${product_pwd_admin_web_service}\n${product_pwd_admin_web_service}" ;}|su - ossadm -c "bash /opt/oss/manager/agent/bin/osskey -cmd encryptpasswd" 2>/dev/null`

echo "es_input: product_pwd_ossadm"
read product_pwd_ossadm
if [ "X${product_pwd_ossadm}" == "X" ];then
    OperateLog "error" "Error: get ossadm passwd failed."
    exit 1
fi
ossadm_passwd_encrypt=`{ echo -e "${product_pwd_ossadm}\n${product_pwd_ossadm}" ;}|su - ossadm -c "bash /opt/oss/manager/agent/bin/osskey -cmd encryptpasswd" 2>/dev/null`

sed -i "s:encrypt(product_pwd_ftpuser):${product_pwd_ftpuser_encrypt}:g" "${installDir}"/input.json
sed -i "s:encrypt(product_pwd_admin_web_service):${admin_webservice_passwd_encrypt}:g" "${installDir}"/input.json
sed -i "s:encrypt(product_pwd_ossadm):${ossadm_passwd_encrypt}:g" "${installDir}"/nodes_NCE.json

if [ -d ${installDir}/commonE ] 
then
    sed -i "s:encrypt(product_pwd_ftpuser):${product_pwd_ftpuser_encrypt}:g" "${installDir}"/commonE/input.json
    sed -i "s:encrypt(product_pwd_admin_web_service):${admin_webservice_passwd_encrypt}:g" "${installDir}"/commonE/input.json
    sed -i "s:encrypt(product_pwd_ossadm):${ossadm_passwd_encrypt}:g" "${installDir}"/commonE/nodes_NCETENANT.json 
fi

exit 0
