#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.backup_kafka_meta_process.log"
    return 0
}

###################################################
#
# 参数个数校验
#
###################################################
function fn_check_param_count()
{
    [[ $# != 1 ]] && fn_sys_log_info "Parameter incorrect." && return 1
    return 0
}

###################################################
#
# 执行远端命令
#
###################################################
function fn_run_command_remote()
{
    fn_sys_log_info "Start executing remote cmds."
    host_ip="$1"
    user="$2"
    passwd="$3"
    command="$4"
    timeout="$5"
    is_log="$6"
    exec_cmd_remote ${host_ip} ${user} "${timeout}" "${command}" ${is_log}<<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && return ${result}
    fn_sys_log_info "Success to execute the remote command." && return 0

}

###################################################
#
# 远端检查是否均已结束
#
###################################################
function fn_check_result_remote()
{
    fn_sys_log_info "Start to invork local check on remote."
    local check_ip_addr="${1}"
    local flag_path="${2}"
    local l_running_times=0
    local l_max_run_times=300
    while [ "${l_running_times}" -le "${l_max_run_times}" ]; do
        sleep 3

        fn_sys_log_info "Waiting for task complete: Elapsed time $((l_running_times*5)) Seconds. "
        fn_sys_log_info "Confirm the check result on the remote node [${check_ip_addr}]."
        fn_run_command_remote "${check_ip_addr}" "${g_remote_user}" "***" "ls ${flag_path};" "5" 0
        result=$?
        [[ ${result} -eq 0 ]] && fn_sys_log_info "Detects that the process execution ends." && return 0
        fn_sys_log_info "Backup process is still running."
        l_running_times=$((l_running_times+1))
    done
    fn_sys_log_error "Check timeout failed and exited."
    return 1
}

###################################################
#
# 生成临时秘钥文件
#
###################################################
function fn_generate_pwd_file()
{
    fn_sys_log_info "Start to generate pwd file."
    echo "${fi_login_password}" > "${src_tmp_pwd_file}"
    fn_sys_log_info "End to generate pwd file."
    return 0
}

###################################################
#
# 拉起远端检查
#
###################################################
function fn_invoke_local_check_remote()
{
    fn_sys_log_info "Invoking on node [${omp_ip}]"
    fn_run_command_remote "${omp_ip}" "${g_remote_user}" "***" "rm -f ${g_process_kafka_backup_flag}" "30"  0
    [[ ! -f ${src_tmp_pwd_file} ]] && fn_sys_log_error "No temp pwd file find." && return 1
    cp_file_to_remote "${omp_ip}" "${user}" "240" "${src_tmp_pwd_file}" "${tar_tmp_pwd_file}" "0" <<EOF
${passwd}
EOF
    ssh -o StrictHostKeyChecking=no ${g_remote_user}@${omp_ip} "nohup sh ${c_path_workspace}/shscript/module/backup_kafka_metadata.sh &"
    rm -f ${src_tmp_pwd_file}
    # 保护进程，根据flag判断进程在超时时间内是否执行完毕。
    fn_check_result_remote "${omp_ip}" "${g_process_kafka_backup_flag}" || return 1
    fn_process_result
    return 0
}
###################################################
#
# 从omp_ip获取FI集群ID并分发到各个节点
#
###################################################
function fn_invoke_get_fi_cluster_id_remote()
{
    fn_sys_log_info "Start to get fi cluster id on remote ${omp_ip}"
    fn_sys_log_info "the user is ${user}"
    [[ ! -f ${src_tmp_pwd_file} ]] && fn_sys_log_error "No temp pwd file find." && reutn 1
    cp_file_to_remote "${omp_ip}" "${user}" "240" "${src_tmp_pwd_file}" "${tar_tmp_pwd_file}" "0" <<EOF
${passwd}
EOF
    [[ $? -ne 0 ]] && fn_sys_log_error "Failed in copy the fi to the remote node [${omp_ip}]." && return 1
    ssh -o StrictHostKeyChecking=no root@${omp_ip} "timeout 1200 sh ${c_path_workspace}/shscript/module/get_fi_cluster_id.sh" > /dev/null 2>&1
    [[ $? -ne 0 ]] && fn_sys_log_error "Failed in invoking the script get_fi_cluster_id of the remote node [${omp_ip}]." && return 1
    cp_file_from_remote "${omp_ip}" "${user}" "240" "${g_upgrade_cluster_id_file}" "${c_root_path}/conf/cluster_id.flag" "0" <<EOF
${passwd}
EOF
    [[ $? -ne 0 ]] && fn_sys_log_error "Failed in get the ${c_path_workspace}/conf/cluster_id.flag from the remote node [${omp_ip}]." && return 1
    fn_sys_log_info "get fi cluster id on remote ${omp_ip} is $(cat ${c_root_path}/conf/cluster_id.flag)"
    for each_ip in ${fi_ip_list}; do
        cp_file_to_remote "${each_ip}" "${user}" "240" "${c_root_path}/conf/cluster_id.flag" "${g_upgrade_cluster_id_file}" "0" <<EOF
${passwd}
EOF
        [[ $? -ne 0 ]] && fn_sys_log_error "Failed in scp ${c_root_path}/conf/cluster_id.flag to the remote node [${each_ip}]." && return 1
        fn_sys_log_info "Succeeded in scp ${c_root_path}/conf/cluster_id.flag to the remote node [${each_ip}]."
    done
    return 0
}
###################################################
#
# 获取所有远程节点上的日志文件，并处理。
#
###################################################
function fn_process_result()
{
    fn_sys_log_info "Obtaining logs from remote nodes."
    remote_node=${omp_ip}
    [[ "$(fn_cp_file_from_remote ${remote_node} "root" "240" "${c_path_workspace}/cmd.backup_kafka_metadata.log" "${c_root_path}/log" "")" == "false" ]] && fn_sys_log_error "Failed to obtain logs from the node [${remote_node}]." && return 1

    return 0
}

###################################################
#
# 汇总日志文件
#
###################################################
function fn_cp_file_from_remote()
{
    fn_sys_log_info "Copy the log files of other nodes to the current node."
    host_ip="$1"
    user="$2"
    timeout="$3"
    c_src_path="$4"
    c_des_path="$5"
    passwd="$6"
    cp_file_from_remote "${host_ip}" "${user}" "${timeout}" "${c_src_path}" "${c_des_path}" "0" <<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to copy files from the remote end." && echo "false" && return 1
    fn_sys_log_info "Success to copy files from the remote end." && echo "true" && return 0
}


###################################################
#
# 解析日志，判断返回正确与否
#
###################################################
function fn_adjust_result()
{
    result=0
    grep -ir "\[ERROR\]" "${c_log_file}" >/dev/null 2>&1;
    [[ $? -eq 0 ]] && result=$((result+1))
    # 没有日志只有一种情况，就是远程命令执行超时，未采集到日志。
    count_res=$(find "${c_root_path}/log/" -name "*cmd.backup_kafka_metadata.log" | wc -l)
    [[ ${count_res} -eq 0 ]] && fn_sys_log_error "No log is generated when the process execution times out." && return 1
    find "${c_root_path}/log/" -name "*cmd.backup_kafka_metadata.log" | xargs -i cat {} | grep "\[ERROR\]" >> "${c_log_file}"
    [[ $? -eq 0 ]] && result=$((result+1))
    return ${result}
}

###############################################################################################
function fn_init()
{
    readonly c_root_path=$(dirname $(readlink -f $0 ))
    source ${c_root_path}/shscript/utils/load_all_util.sh
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    readonly c_log_file="$(fn_get_log_file_path)"
    rm -f "${c_log_file}"
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"
    source "${c_root_path}/shscript/profile/${scene_name}_profile.sh"

    return 0
}

###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    fn_check_param_count "$@" || return 1
    fn_sys_assert_in_range "scene_name" "backup_kafka,upgrade,rollback,no_rollback"
    fn_sys_assert_not_null "g_upgrade_param" || return 1
    fn_sys_assert_is_file "g_upgrade_param" || return 1
    [[ "$(fn_sys_is_valid_ip "${omp_ip}")" == "false" ]] && fn_sys_log_error "The OMP IP address in the configuration file is invalid." && return 1

    return 0
}

###############################################################################################
function fn_do()
{
    fn_sys_log_info "Start to backup remote..."
    fn_generate_pwd_file
    fn_invoke_get_fi_cluster_id_remote
    [[ $? -ne 0 ]] && fn_sys_log_error "Failed in get fi_cluster_id the fi to the remote node." && return 1
    if [[ "x${g_fi_client_ip}" == "x" ]]; then
        fn_sys_log_info "invoke process fi on ${omp_ip}..."
        ssh -o StrictHostKeyChecking=no ${g_remote_user}@${omp_ip} "sh ${c_path_workspace}/shscript/module/process_fi.sh"
        [[ $? -ne 0 ]] && fn_sys_log_error "Failed in process fi on the remote node." && return 1
    else
        fn_sys_log_info "invoke process fi on ${g_fi_client_ip}..."
        ssh -o StrictHostKeyChecking=no ${g_remote_user}@${g_fi_client_ip} "sh ${c_path_workspace}/shscript/module/process_fi.sh"
        [[ $? -ne 0 ]] && fn_sys_log_error "Failed in process fi on the remote node." && return 1
    fi
    fn_invoke_local_check_remote
    invoke_result=$?
    if [[ ${invoke_result} -eq 124 ]]; then
        fn_sys_log_info "Retry to invoke backup remote..."
        fn_invoke_local_check_remote || fn_sys_log_error "Failed to invoke backup remote." && return 1
    elif [[ ${invoke_result} -eq 1 ]]; then
        fn_sys_log_error "Failed to invoke backup remote."
        return 1
    fi
    fn_sys_log_info "wait 10s and do process fi again..."
    sleep 10
    if [[ "x${g_fi_client_ip}" == "x" ]]; then
        fn_sys_log_info "invoke process fi twice on ${omp_ip}..."
        ssh -o StrictHostKeyChecking=no ${g_remote_user}@${omp_ip} "sh ${c_path_workspace}/shscript/module/process_fi.sh"
        [[ $? -ne 0 ]] && fn_sys_log_error "Failed in process fi on the remote node." && return 1
    else
        fn_sys_log_info "invoke process fi twice on ${g_fi_client_ip}..."
        ssh -o StrictHostKeyChecking=no ${g_remote_user}@${g_fi_client_ip} "sh ${c_path_workspace}/shscript/module/process_fi.sh"
        [[ $? -ne 0 ]] && fn_sys_log_error "Failed in process fi on the remote node." && return 1
    fi
    fn_sys_log_info "End to backup remote"
    return 0
}

###############################################################################################
function fn_main()
{

    readonly c_start_time="$(date +%s)"
    scene_name=${1}
    fn_init || return 1
    fn_sys_log_enter
    fn_precheck "$@" || return 1
    fn_do || return 1
    fn_adjust_result

    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_leave "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    return "$l_result"
}

###############################################################################################
echo -n "Enter the password for logging in to FusionInsight: "
IFS=$'\n'
read -sr fi_login_password
echo -e "\n"

fn_main "$@"
result="$?"
fn_sys_audit_log "${result}" "Init Check" "Execute remote_launch "
exit "${result}"
