#!/bin/bash

#-----------------------------------------------------------------------------------------------------------------
#func : 检查cpu核数是否与配置文件匹配(物理核数=cpu数*单个cpu核数)
#param : cpu总核数
#-----------------------------------------------------------------------------------------------------------------
check_cpu_core_num()
{

    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking cpu core num."
    #cpuCoreNum只能是整数
    check_details_conf="$(dirname "$0")/../../conf/resource/check_details.conf"
    conf_cpu=$(cat "${check_details_conf}" | grep "cpu" | awk -F':' '{print $NF}')
    if [[ "${conf_cpu}" =~ [[:digit:]]+ ]]
    then
        totalCoreNum=$(cat /proc/cpuinfo |grep "processor"|sort -u|wc -l)

        if [ "${totalCoreNum}" -ge ${conf_cpu} ]
        then
            fn_sys_log_info "${host_ip}: the cpu cores number '${totalCoreNum}' match the config file $1."
        else
            fn_sys_log_error "${host_ip}: the cpu cores number '${totalCoreNum}' does not match the config file $1."
        fi
    else
        fn_sys_log_info "${host_ip}: the cpu cores number $1 format is not correct, it should be integer."
    fi
    fn_sys_log_info "${host_ip}: Success checking cpu core num."
}

#-----------------------------------------------------------------------------------------------------------------
#func : 检查内存大小是否与配置文件匹配
#param : 内存大小
#-----------------------------------------------------------------------------------------------------------------
check_memory()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking memory size."

    #memory可以使整数或浮点数
    check_details_conf="$(dirname "$0")/../../conf/resource/check_details.conf"
    conf_mem=$(cat "${check_details_conf}" | grep "mem" | awk -F':' '{print $NF}')
    if [[ "${conf_mem}" =~ [[:digit:]]+[\.]?[[:digit:]]* ]]
    then
        realMemory=$(free -g | sed -n '2p' | awk '{print $2}')
        # 10% less is ok
        configMemory=$(echo ${conf_mem}*0.9 | bc)
        ifMoreThanLowerBound=$(echo "${realMemory} > ${configMemory}" | bc)
        if [[ "${ifMoreThanLowerBound}" -ne 0 ]]
        then
            fn_sys_log_info "${host_ip}: real memory size ${realMemory} match the config file $1, 10% less (${configMemory}) is OK."
        else
            fn_sys_log_error "${host_ip}: real memory size ${realMemory} does not match the config file $configMemory."
        fi
    else
        fn_sys_log_error "${host_ip}: the memory size $1 format is not correct, it should be integer or float number."
    fi
    fn_sys_log_info "${host_ip}: Success checking memory size."
}

check_nic_speed()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking the network port rate."
    check_details_conf="$(dirname "$0")/../../conf/fi_cluster_check.conf"
    Business_nic=$(cat "${check_details_conf}" | grep "^nic" | awk -F'=' '{print $NF}')

    dmidecode -t 1 | grep 'Manufacturer' | grep 'VMware\|Xen\|OpenStack\|QEMU\|Cloud' > /dev/null 2>&1
    [[ $? -eq 0 ]] && fn_sys_log_info "No need to check the network port rate." && return
    nic_speed=$(ethtool ${Business_nic} | grep -iE "Speed" | grep -o '[0-9]\+')
    [[ $? -ne 0 ]] && fn_sys_log_error "${host_ip}: The NIC speed should be greater than 1000 MB/s, but the NIC speed fails to be obtained."
    [[ ${nic_speed} -lt 1000 ]] && fn_sys_log_error "${host_ip}: The NIC speed should be greater than 1000 MB/s."
    fn_sys_log_info "${host_ip}: Success checking the network port rate."
}

