#!/bin/bash

function fn_get_log_file_path()
{
    echo "${current_path}/../../cmd.confirm_local_process.log"
}

function fn_init()
{
    readonly current_path=$(dirname $(readlink -f $0 ))

    # Loading Modules
    source ${current_path}/../utils/load_all_util.sh
    readonly c_root_path=$(cd ${current_path}/../../ && pwd && cd - &>/dev/null)

    # Initialization Log
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    readonly c_log_file="$(fn_get_log_file_path)"
    [[ -f ${c_log_file} ]] && rm -f ${c_log_file}
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"

    source "${c_root_path}/shscript/profile/upgrade_profile.sh"
    rm -rf "${c_root_path}/python" >/dev/null 2>&1;
    return 0
}

function fn_prepare()
{
    fn_sys_log_info "Start to execute preparing."
    fn_clear_step_flag
    rm -f ${g_namenode_copy_flag}
    fn_sys_log_info "End to execute preparing."

    return 0
}

function fn_check()
{
    fn_sys_log_info "Start to execute checking."

    fn_sys_assert_current_user_matched "root" || return 1
    fn_sys_assert_is_ip "omp_ip" || return 1
    fn_sys_assert_not_null "g_fi_install_path" || return 1

    fn_sys_log_info "End to execute checking."
    return 0
}

# 2.0 删除FI备份的srv目录下的备份数据目录 -- 非元数据
function fn_rollback_srv_business_data()
{
    fn_sys_log_info "Start to backup business data in /srv/Bigdata."
    find /srv/BigData/ -maxdepth 4 -name backup | xargs -i rm -rf {}
    count_find=$(find /srv/BigData/ -maxdepth 4 -name backup | wc -l)
    [[ ${count_find} != 0 ]] && fn_sys_log_error "Cleanup is not complete." && return 1

    fn_sys_log_info "Start to delete nm backup dir /srv/BigData/hadoop/data1/nm/containerlogs_backup /srv/BigData/hadoop/data1/nm/localdir_backup."
    rm -rf /srv/BigData/hadoop/data1/nm/containerlogs_backup
    rm -rf /srv/BigData/hadoop/data1/nm/localdir_backup

    [[ -f "${namenode_flag_path}/restore_data.flag" ]] && rm -f "${namenode_flag_path}/restore_data.flag"

    fn_sys_log_info "End to backup business data in /srv/Bigdata."
    return 0
}

# 3.0 删除FusionInsight目录。
function fn_remove_fi_dir()
{
    fn_sys_log_info "Start to delete the FusionInsight installation directory."
    [[ -d ${g_fi_install_path} ]] && rm -rf ${g_fi_install_path}
    [[ -d ${g_fi_install_path} ]] && fn_sys_log_error "Failed to delete the FusionInsight installation directory." && return 1

    find /srv/BigData/ -maxdepth 1 -uid 2000 | xargs -i rm -rf {}
    find /tmp -maxdepth 1 -uid 2000 | xargs -i rm -rf {}
    find /tmp -maxdepth 1 -uid 2100 | xargs -i rm -rf {}
    chown root:root /etc/rsyslog.conf

    rm -rf /opt/huawei
    rm -rf /var/log/Bigdata
    rm -f /var/log/restore_package.log
    rm -f /var/log/ipmitool.fi.log
    rm -f /opt/backup/ncendpsys/backup/etc/openldap/ldap.conf

    rm -f /var/spool/cron/omm
    rm -f /var/spool/mail/omm
    rm -rf /var/lib/sss/db/*
    service sssd restart
    rm -f /tmp/*.plock
    rm -f /tmp/D55E11D4CE9921E3AF1110943F8AF3CCE7431BC9FBEF5B2B5D8354DDF193823C
    rm -f /tmp/_wcc_file_locker_

    [[ -d /var/log/Bigdata ]] && chown ossuser:ossgroup /var/log/Bigdata
    fn_sys_log_info "End to delete the FusionInsight installation directory."
    return 0
}

# 4.0 删除omm,ommdba。
function fn_remove_fi_user()
{
    fn_sys_log_info "Start to remove FusionInsight users."
    id omm
    [[ $? == 0 ]] && fn_sys_log_info "Start to delete omm user." && userdel -rf omm
    id omm
    [[ $? == 0 ]] && fn_sys_log_error "Failed to delete user omm." && return 1
    id ommdba
    [[ $? == 0 ]] && fn_sys_log_info "Start to delete omm user." && userdel -rf ommdba
    id ommdba
    [[ $? == 0 ]] && fn_sys_log_error "Failed to delete user omm." && return 1
    fn_sys_log_info "End to remove FusionInsight users."

    sed -i '/^omm/d' /etc/cron.allow

    return 0
}

# 5.0 删除备份信息。
function fn_process_backup_file()
{
    fn_sys_log_info "Start to remove backup file."
    [[ -d ${g_backup_path} ]] && rm -rf ${g_backup_path}
    fn_sys_log_info "End to remove backup file."
    return 0
}


# 1.0 接入hdfs文件系统，将hdfs回退功能锁定。
function fn_process_hdfs_system_facl()
{
    fn_sys_log_info "Start to execute finalizeUpgrade hdfs/hadoop.hadoop.com on hdfs on first FusionInsight node."

    ip a | grep -w "${omp_ip}"
    [[ $? != 0 ]] && fn_sys_log_info "This is not the first FusionInsight node, skip this step." && return 0

    source /opt/oss/*/apps/NdpNameNodeService/etc/HDClient/bigdata_env
    kinit -kt /opt/oss/*/apps/NdpNameNodeService/etc/hdfs.keytab hdfs/hadoop.hadoop.com
    before_report_log=$(hdfs dfsadmin -report)
    fn_sys_log_info "Before finalizeUpgrade:"
    fn_sys_log_info "${before_report_log}."
    hdfs dfsadmin -finalizeUpgrade
    [[ $? != 0 ]] && fn_sys_log_error "Unable to execute finalizeUpgrade hdfs/hadoop.hadoop.com on hdfs." && return 1
    after_report_log=$(hdfs dfsadmin -report)
    fn_sys_log_info "After finalizeUpgrade:"
    fn_sys_log_info "${after_report_log}."

    fn_sys_log_info "End to change the facl of file in hdfs."
    return 0;
}

# 6.0 删除升级目录，删除锁住的升级标志位。
function fn_process_upgrade_file()
{
    fn_sys_log_info "Start to remove upgrade flag."
    su - ossuser -c "rm -f /tmp/redis_aof_flag"
    rm -f ${aof_flag_path}
    [ -f "${g_upgrade_flag}" ] &&  chattr -i ${g_upgrade_flag} && rm -rf ${g_upgrade_Dir}
    [ -f "${g_upgrade_replace_flag}" ] &&  chattr -i ${g_upgrade_replace_flag} && rm -rf ${g_upgrade_replace_flag}
    fn_sys_log_info "Start to remove upgrade directory."
    rm ${g_upgrade_Dir} -rf
    [ -d "${g_upgrade_Dir}" ] && fn_sys_log_error "Failed to remove upgrade directory." && return 1
    return 0
}

function fn_do()
{
    # 1.0 接入hdfs文件系统，将hdfs回退功能锁定。
    fn_process_hdfs_system_facl || return 1

    # 2.0 删除FI备份的srv目录下的备份数据目录 -- 非元数据
    fn_rollback_srv_business_data || return 1

    # 3.0 删除FusionInsight目录。
    fn_remove_fi_dir || return 1

    # 4.0 删除omm,ommdba。
    fn_remove_fi_user || return 1

    # 5.0 删除备份信息。
    fn_process_backup_file || return 1

    # 6.0 删除升级目录，删除锁住的升级标志位。
    fn_process_upgrade_file || return 1

    return 0
}

function exit_create_flag()
{
    err_msg=$1
    fn_sys_log_error "${err_msg}"
    touch ${g_process_confirm_flag}
    return 1
}

function fn_main()
{
    c_start_time="$(date +%s)"
    fn_init || exit_create_flag "Start to create the flag file and exit." || return 1
    fn_check || exit_create_flag "Start to create the flag file and exit." || return 1
    fn_prepare || exit_create_flag "Start to create the flag file and exit." || return 1
    fn_do
    local l_result="$?"
    touch ${g_process_confirm_flag}
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_info "Leave post_install with status [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    [[ ${l_result} -ne 0 ]] && fn_sys_log_error "Failed to run confirm_local script."
    return "$l_result"
}

###############################################################################################
fn_main
result="$?"
exit "$result"
