#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.process_fi.log"
    return 0
}

###############################################################################################
function fn_init()
{
    readonly c_script_path=$(dirname $(readlink -f $0 ))
    # Loading Modules
    readonly c_root_path=${c_script_path}/../../
    source ${c_root_path}/shscript/utils/load_all_util.sh
    source ${c_root_path}/shscript/profile/upgrade_profile.sh

    # Initialization Log
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"

    readonly c_log_file="$(fn_get_log_file_path)"
    readonly fi_install_path="/opt/huawei/Bigdata"

    [[ -f ${c_log_file} ]] && rm -f ${c_log_file}
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"

    return 0
}


###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    fn_sys_assert_is_directory "fi_install_path" || fn_sys_log_warn "The node is not the node where the FusionInsight is installed."

    return 0
}

###############################################################################################
#
# saveNamespace 处理hbase升级过程产生的问题
#
###############################################################################################
function fn_save_namenode()
{
    if [[ "x${g_fi_client_path}" == "x" ]]; then
      local client_path="/opt/client"
    else
      local client_path=${g_fi_client_path}
    fi
    fn_sys_log_info "the local client path is ${client_path}"
    [[ ! -f ${client_path}/bigdata_env ]] && fn_sys_log_info "In the enterprise scenario, skip processing HBase." && return 0
    fn_sys_log_info "Handle the HBase snapshot task first."

    keytab_path=$(find ${fi_install_path} -name hdfs.keytab | head -1)
    source ${client_path}/bigdata_env
    kinit -kt ${keytab_path} hdfs/hadoop.hadoop.com >> $c_log_file 2>&1
    if [[ $? -ne 0 ]]; then
        fn_sys_log_warn "Fail to kinit hdfs/hadoop.hadoop.com"
    else
        fn_sys_log_info "kinit hdfs/hadoop.hadoop.com success."
    fi
    # 兼容NCE-E容灾域名不一致的场景
    kinit -kt ${client_path}/user.keytab cloud_manager >> $c_log_file 2>&1
    if [[ $? -ne 0 ]]; then
      fn_sys_log_warn "Fail to kinit cloud_manager"
    else
      fn_sys_log_info "kinit cloud_manager success."
    fi

    fn_sys_log_info "Start to disallowSnapshot."
    hdfs dfs -ls /hbase/.snapshot >> $c_log_file 2>&1
    snap_info=$(hdfs dfs -ls /hbase/.snapshot)
    snap_path=$(echo ${snap_info} | awk -F '/' '{print $NF}')
    fn_sys_log_info "${snap_path}"
    if [[ "$snap_path" =~ "default-" ]]; then
        fn_sys_log_info "Start to do disallowSnapshot."
        hdfs dfs -deleteSnapshot /hbase ${snap_path} >> $c_log_file 2>&1
        hdfs dfsadmin -disallowSnapshot /hbase >> $c_log_file 2>&1
        local l_result="$?"
        fn_sys_log_info "End to disallowSnapshot."
        [[ ${l_result} -ne 0 ]] && fn_sys_log_error "DisallowSnapshot failed." && return 1
    fi

    fn_sys_log_info "Start to saveNamespace."
    hdfs dfsadmin -safemode enter >> $c_log_file 2>&1
    [ $? -ne 0 ] && fn_sys_log_error "Fail to enter the hdfs safemode!"
    hdfs dfsadmin -saveNamespace >> $c_log_file 2>&1
    local l_result="$?"
    [ ${l_result} -ne 0 ] && fn_sys_log_error "Fail to saveNamespace!"
    hdfs dfsadmin -safemode leave >> $c_log_file 2>&1
    [ $? -ne 0 ] && fn_sys_log_error "Fail to leave the hdfs safemode!"
    fn_sys_log_info "End to saveNamespace."

    [[ ${l_result} -ne 0 ]] && fn_sys_log_error "Handle the HDFS fsimage task failed." && return 1
    fn_sys_log_info "Handle the HBase snapshot task success."

    return 0
}

###############################################################################################
function fn_do()
{
    fn_precheck || return 1
    local running_times=0
    local total_times=3
    while [ ${running_times} -lt ${total_times} ]; do
        fn_save_namenode && return 0
        sleep 2
        ((running_times+=1))
    done

    return 1
}

###############################################################################################
function fn_main()
{
    readonly c_start_time="$(date +%s)"
    fn_init
    fn_sys_log_info "Start to process fi."
    fn_do
    local l_result="$?"

    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_info "Leave process_fi.sh with status [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    [[ ${l_result} -ne 0 ]] && fn_sys_log_error "Failed to run backup kafka."
    return "$l_result"
}

###############################################################################################

fn_main "$@"
result="$?"
exit "$result"
