#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"
TMP_PATH="/opt/oss/log/manager/easysuite_upgrade_config"

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    # ossadm用户 ID 3001
    if [ "$(whoami)" != "$(id -nu 3001)" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 记录执行日志
##################################################
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    # 记录日志文件,打印标准输出和标准错误输出
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" 1>&2
}

# 获取产品数据
function get_upgrade_data()
{
    # 产品名
    PRODUCTNAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    [ -z "${PRODUCTNAME}" ] && return 1

    # 源版本
    SRC_VERSION=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['src_version'])" 2>/dev/null)
    [ -z "${SRC_VERSION}" ] && return 1

    # 目标版本
    DES_VERSION=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['des_version'])" 2>/dev/null)
    [ -z "${DES_VERSION}" ] && return 1
    return 0
}

##########################################
# 创建升级任务
##########################################
function main()
{
    # 检查执行用户
    check_user || return 1

    # 创建日志目录
    [ ! -d "${LOG_PATH}" ] && mkdir -p ${LOG_PATH}

    # 检查入参
    INPUTPATH="${2}"
    [ -z "${INPUTPATH}" -o ! -d "${INPUTPATH}" ] && return 1

    # 升级任务信息
    get_upgrade_data || return 1

    # containerlist文件备份路径
    container_file=/opt/upgrade/backup/pre_upgrade/"${SRC_VERSION}-${DES_VERSION}"/"${PRODUCTNAME}"/containerlist.json

    # 配置文件
    if [ ! -f "${container_file}" ]
    then
        LOG "ERROR" "The file($(basename ${container_file})) is not existed."
        return 1
    fi

    # 加载平台环境变量
    source /opt/oss/manager/bin/engr_profile.sh
    export SSL_ROOT=/opt/oss/manager/etc/ssl
    export CIPHER_ROOT=/opt/oss/manager/etc/cipher

    # 执行脚本
    py_script="${SCRIPT_PATH}"/pyscripts/delete_diff_db_instance.py
    # 文件不存在使用pyc
    [ ! -f "${py_script}" ] && py_script="${py_script}c"
    # 调用脚本打印调用信息
    LOG "INFO" "Start to execute $(basename ${py_script})"

    python "${py_script}" "${INPUTPATH}" "${container_file}" | tee -a "${LOG_FILE}"
    # PIPESTATUS获取tee管道前命令返回值
    if [ ${PIPESTATUS[0]} -ne 0 ]
    then
        LOG "ERROR" "Failed to execute $(basename ${py_script})"
        return 1
    fi
    LOG "INFO" "Finished to execute $(basename ${py_script})"
}

main "$@"
exit $?
