#!/usr/bin/python
# -*- coding: utf-8 -*-
import re
import time
import traceback

from getDBConnection import get_zenith_session
import common_tasks.const_sql as const_sql
from common_tasks.base_task import BaseTask

ONE_PACKAGE = 500


class UpgradeSshFingerprint(BaseTask):
    def __init__(self, product_name="NCE"):
        super(UpgradeSshFingerprint, self).__init__()
        self.set_product_name(product_name)
        self.info("UpgradeSshFingerprint init product_name is %s" % product_name)
        self.src_db_session = get_zenith_session('DamDB', 'DamDB', product_name)
        if self.src_db_session is None:
            self.error("DamDB is None")
            return
        self.src_db_session.autocommit(True)
        self.src_db_cursor = self.src_db_session.cursor()

        self.dst_db_session = get_zenith_session('neresdb', 'neresdb', product_name)
        if self.dst_db_session is None:
            self.error("neresdb is None")
            return
        self.dst_db_session.autocommit(True)
        self.dst_db_cursor = self.dst_db_session.cursor()

        self.src_table = "tbl_SshFingerprint"
        self.src_table_cols = ("DevID", "DevIP", "Fingerprint", "NewFingerprint")
        self.src_table_cols_index = {y:x for x, y in enumerate(self.src_table_cols)}
        self.dst_table = "SshFingerprint"
        self.dst_table_cols = ("tenantId", "neResId", "neId", "trustedFingerprint", "unTrustedFingerprint",
                               "createAt", "updateAt")
        self.idmapping_dic = {}

    def get_resid_from_idmapping(self, paras):
        idmappingdb_sess = get_zenith_session('idmappingdb', 'idmappingdb', self.product_name)
        if idmappingdb_sess is None:
            self.error("get idmappingdb_sess session fail")
            return
        idmappingdb_sess.autocommit(True)
        id_mapping_cursor = idmappingdb_sess.cursor()

        tmp_table_name = "tmp_neid_%s" % self.dst_table
        id_mapping_cursor.execute(const_sql.DROP_TEMP_TABLE %tmp_table_name)
        id_mapping_cursor.execute(const_sql.CREATE_TEMP_TABLE % tmp_table_name)
        insert_stmt = "insert into tmp_%s values(:1)" % tmp_table_name

        nativeIds = []
        for para in paras:
            data = []
            nativeId = "NE=%s" % para[self.src_table_cols_index.get("DevID")]
            data.append(nativeId)
            tuple_data = tuple(data)
            nativeIds.append(tuple_data)
            if len(nativeIds) == ONE_PACKAGE:
                id_mapping_cursor.executemany(insert_stmt, nativeIds)
                self.debug("one package:%s"%nativeIds)
                nativeIds = []

        if len(nativeIds) != 0:
            id_mapping_cursor.executemany(insert_stmt, nativeIds)
            self.debug("last package datas: %s" % nativeIds)

        query_stmt = const_sql.INNER_JOIN_TEMP_TABLE % tmp_table_name
        self.debug("query sql: %s" % query_stmt)
        id_mapping_cursor.execute(query_stmt)
        result = id_mapping_cursor.fetchall()

        for r in result:
            l = list(r)
            self.idmapping_dic[l[1].lstrip("NE=")] = l[0]
            self.debug("result: %s: %s" % (l[1], l[0]))

        id_mapping_cursor.execute(const_sql.DROP_TEMP_TABLE % tmp_table_name)
        id_mapping_cursor.close()
        idmappingdb_sess.close()

    def convert_data(self, paras):
        tenantId = "default-organization-id"
        neResId = self.idmapping_dic.get(str(paras[self.src_table_cols_index.get("DevID")]))
        neId = paras[self.src_table_cols_index.get("DevID")]
        trustedFingerprint = paras[self.src_table_cols_index.get("Fingerprint")]
        unTrustedFingerprint = paras[self.src_table_cols_index.get("NewFingerprint")]
        createAt = str(int(time.time() * 1000))
        updateAt = str(int(time.time() * 1000))

        return tuple(None if x is None else str(x) for x in (tenantId, neResId, neId, trustedFingerprint, unTrustedFingerprint,
                                                     createAt, updateAt))

    def to_UpgradePara(self, datas):
        self.get_resid_from_idmapping(datas)
        col_names = "`" + ("`, `".join(self.dst_table_cols)) + "`"
        val_ids = ":" + (",:".join((str(x+1) for x in range(len(self.dst_table_cols)))))
        insert_stmt = "INSERT INTO `%s` (%s) VALUES(%s)" % (self.dst_table, col_names, val_ids)
        self.debug("insert sql stmt: %s" % insert_stmt)
        list_datas = []
        for data in datas:
            self.debug("original data is: %s, length is:%s" % (data, len(data)))
            data = self.convert_data(data)
            self.debug("coverted date is: %s, length is:%s"%(data, len(data)))
            if len(data) == len(self.dst_table_cols):
                tuple_data = tuple(data)
                list_datas.append(tuple_data)
            if len(list_datas) == ONE_PACKAGE:
                self.exec_sql(insert_stmt, list_datas)
                list_datas = []

        if len(list_datas) != 0:
            self.exec_sql(insert_stmt, list_datas)

    def close_session(self):
        self.dst_db_cursor.close()
        self.dst_db_session.close()
        self.src_db_cursor.close()
        self.src_db_session.close()

    def do(self):
        try:
            self.info('UpgradeSshFingerprint::do start!')
            select_stmt = "select %s from %s where DevID != 0" % \
                          (",".join(self.src_table_cols), self.src_table)
            datas = self.exec_query_sql(self.src_db_cursor, select_stmt)
            self.info('get para data success count:%d'%len(datas))

            self.to_UpgradePara(datas)
            self.info('to_UpgradePara done')
            self.close_session()
        except Exception as e:
            self.close_session()
            self.error('UpgradeSshFingerprint got exception')
            self.error(traceback.format_exc())
            return -1
        self.info('UpgradeSshFingerprint::do done')
        return 0


if __name__ == '__main__':

    tool = UpgradeSshFingerprint()
    print('[INFO] UpgradeSshFingerprint start>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
    tool.do()
    print('[INFO] UpgradeSshFingerprint finished<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
