﻿# coding: utf-8
"""
功 能：sopuser用户密码有效性检查
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import logging
import json
import os

from utils.sshUtil import CsshCmd
from utils.sshUtil import SSHClient
from utils.thread_util import MultiThreadPool
from utils.log_util import EasysuiteLogger
from easysuite import settings
from taskmgr.status_manager.sub_item_status_mgr import sub_item_decorate
from func.upgrade.common.upgrade_local_ssh import UpgradeLocalSsh
from func.upgrade.upgrade_operation_mgr.common.upgrade_util import UpgradeUtil

LOCAL_LOGGER = logging.getLogger(__name__)


def execute_task_check(kvs):
    """
    功能描述: 检查节点关键文件是否存在
    :return: 执行结果
    """
    try:
        logger = EasysuiteLogger.get_logger(kvs, "task_check_critical_file")
        sub_item_mgr.save_single_sub_item("task_check_critical_file")
        logger.easysuite_start("begin to check")
        thread_pool = MultiThreadPool()
        ssh_nodes_param = get_node_connect_info(kvs)
        for site, ssh_node in ssh_nodes_param.items():
            if not ssh_node.get("login_ip"):
                continue
            if UpgradeLocalSsh.is_es_node(ssh_node.get("login_ip")):
                ips = _get_all_node_ips()
            elif site == "arbit":
                ips = [ssh_node.get("login_ip")]
            else:
                result, out_put = CsshCmd.exec_shell_cmd_su_exec(ssh_node.get("login_ip"), ssh_node.get("login_user"),
                                                                 ssh_node.get("login_pwd"), _get_remote_ips_cmd(),
                                                                 ssh_node.get("su_user"), ssh_node.get("su_pwd"),
                                                                 proxy_param=None)
                if not result:
                    logger.easysuite_error("out_put={}".format(out_put))
                    logger.easysuite_error("get remote ips failed.")
                    flag = False
                    continue
                ips = out_put.strip().split(',')
            for ip in ips:
                if not ip:
                    continue
                thread_pool.add_thread(check_file, ip, ssh_node, logger)
        # 处理检查结果信息
        results = thread_pool.execute_with_result()
        failed_results = [result for result in results if not result]
        if failed_results:
            logger.easysuite_error("key operating system files check failed.")
            return False
        logger.easysuite_finish("key operating system files check success.")
        sub_item_mgr.update_single_sub_item_status(logger, "finish")
        return True
    except Exception as e:
        logger.easysuite_error("Execute check task exception.{}".format(e))
        sub_item_mgr.update_single_sub_item_status(logger, "error")
        return False


def execute_check_cmd(ip, ssh_node, cmd):
    """
    执行检查命令
    :param ssh_node:
    :return:
    """
    ssh_para = "-o ConnectTimeout=30 -o stricthostkeychecking=no -o ConnectionAttempts=5 -o " \
               "ServerAliveInterval=3 -o ServerAliveCountMax=20"
    if ssh_node.get("node_name") == "node_arbitrate":
        cmd = f"result=$(su - ossadm -c \"{cmd}\" 2>>/dev/null);echo $result"
    elif ip:
        cmd = f"result=$(su - ossadm -c \"ssh {ssh_para} {ip} {cmd}\" 2>>/dev/null);echo $result"
    if UpgradeLocalSsh.is_es_node(ssh_node.get("login_ip")):
        return UpgradeLocalSsh.send_admin_local_cmd(ssh_node.get("su_pwd"), cmd,
                                                    node_ip=ssh_node.get("login_ip"))
    else:
        return CsshCmd.exec_shell_cmd_su_root(ssh_node.get("login_ip"), ssh_node.get("login_user"),
                                              ssh_node.get("login_pwd"), cmd, ssh_node.get("su_pwd"),
                                              proxy_param=None)


def check_file(ip, ssh_node, logger):
    """
    检查文件
    """
    return check_file_content(ip, ssh_node, logger) and check_yum(ip, ssh_node, logger)


def check_file_content(ip, ssh_node, logger):
    """
    检查节点文件是否存在
    """
    fileName = "/etc/euleros-latest"
    fileContent = "eulerversion"
    cmd = "grep -i '{}' {} && echo 'success' || echo 'failed'".format(fileContent,fileName)
    flag, check_result = execute_check_cmd(ip, ssh_node, cmd)
    if not flag or check_result == '':
        logger.easysuite_error("node %s Execute check scripts failed." % ssh_node.get("login_ip"))
        return False
    if "success" not in check_result:
        logger.easysuite_error("node {} the {} does not exist or the content is incorrect.".format(ip, fileName))
        return False
    return True


def check_yum(ip, ssh_node, logger):
    """
    检查节点文件是否存在
    """
    fileName = "/bin/yum"
    cmd = "[ -f {} ] && echo \"success\" || echo \"failed\"".format(fileName)
    flag, check_result = execute_check_cmd(ip, ssh_node, cmd)
    if not flag or check_result == '':
        logger.easysuite_error("node %s Execute check scripts failed." % ssh_node.get("login_ip"))
        return False
    if "success" not in check_result:
        logger.easysuite_error("node {} the {} does not exist.".format(ip, fileName))
        return False
    return True


def _get_all_node_ips():
    node_ips = []
    with open(f'/opt/oss/manager/etc/sysconf/nodelists.json', mode='r') as nodelists:
        data = json.load(nodelists)
        for k, v in data.get('nodeList').items():
            for item in v.get('IPAddresses'):
                if 'maintenance' in item.get('usage'):
                    node_ips.append(item.get('IP'))
    return node_ips


def _get_remote_ips_cmd():
    """
    远端站点执行获取节点ip列表的命令
    :return:
    """
    return f'''su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python -c \\"
import json
ips = ''
with open('/opt/oss/manager/etc/sysconf/nodelists.json', mode='r') as nodelists:
  data = json.load(nodelists)
  for k, v in data.get('nodeList').items():
    for item in v.get('IPAddresses'):
      if 'maintenance' in item.get('usage'):
       ips += item.get('IP') + ',' 
  print(ips)
\\""'''


def get_node(kvs, node_name, is_arbit=None):
    """
    封装节点信息
    """
    if is_arbit:
        login_ip = UpgradeUtil.get_value_from_main(kvs.get("easysuite.task_id"), "arbitrate_ip")
        login_user = kvs.get("{}_login_user".format(node_name))
        login_pwd = kvs.get("{}_login_pwd".format(node_name))
    else:
        login_ip = kvs.get('{}_ip'.format(node_name))
        login_user = kvs.get("standby_login_user")
        login_pwd = kvs.get('{}_{}_pwd'.format(node_name, login_user))
    return {
        'login_ip': login_ip,
        'login_user': login_user,
        'login_pwd': login_pwd,
        'su_user': "root",
        'su_pwd': kvs.get('{}_root_pwd'.format(node_name)),
        'ssh_port': kvs.get('{}_ssh_port'.format(node_name)),
        'sftp_port': kvs.get('{}_sftp_port'.format(node_name)),
        'node_name': node_name
    }


def get_node_connect_info(kvs):
    """
    获取节点登录信息
    """
    ssh_node_dict = {}
    # 非单管场景
    if kvs.get("is_arbitration_exist") == "yes":
        arbit_node = get_node(kvs, "node_arbitrate", True)
        ssh_node_dict.update({"arbit": arbit_node})
    if kvs.get("single_mgr_domain") == "no":
        master_node = get_node(kvs, "node_omp01")
        ssh_node_dict.update({"node": master_node})
        # 异地容灾场景
        if kvs.get("protection") == 'id_protection_hot':
            standby_node = get_node(kvs, "node_standby_omp01")
            ssh_node_dict.pop("node")
            ssh_node_dict.update({"master": master_node})
            ssh_node_dict.update({"standby": standby_node})
    # 单管场景
    else:
        master_node = get_node(kvs, "node_nmsserver")
        ssh_node_dict.update({"node": master_node})
        # 异地容灾场景
        if kvs.get("protection") == 'id_protection_hot':
            standby_node = get_node(kvs, "node_standby_nmsserver")
            ssh_node_dict.pop("node")
            ssh_node_dict.update({"master": master_node})
            ssh_node_dict.update({"standby": standby_node})
    return ssh_node_dict


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: 检查结果
    """
    login_user = kvs.get("os_type", "")
    return login_user == "Euler"


global sub_item_mgr


@sub_item_decorate
def exe(kvs):
    return [[('', '', execute_task_check(kvs))]]
