import os
import json
from util import ossext


def read_password():
    os_pass_wd = os.getenv('omp_default_key')
    user_pwd_pass_wd = os.getenv('omp_new_sopuser')
    en_os_pass_wd = ossext.Cipher.encrypt(os_pass_wd)
    en_user_pwd_pass_wd = ossext.Cipher.encrypt(user_pwd_pass_wd)
    return [
        {'name': 'ossadm', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'sopuser', 'value': en_user_pwd_pass_wd, 'encrypt': 'yes'},
        {'name': 'ossuser', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'zenith-sys', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'zenith-dbmtuser', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'redis-dbuser', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'redis-dbmtuser', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'er_cert', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'dbuser', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'db-default-value', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'protect_pvalue', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'web_admin_user_name', 'value': 'admin'},
        {'name': 'web_admin_user_value', 'value': en_os_pass_wd, 'encrypt': 'yes'},
        {'name': 'default_pvalue', 'value': en_os_pass_wd, 'encrypt': 'yes'}
    ]


def create_pw_file(json_path):
    json_obj = read_password()
    path = os.path.join(json_path, 'nce_upgrade_params.json')
    with os.fdopen(os.open(path, os.O_CREAT | os.O_WRONLY | os.O_TRUNC, mode=0o600), 'w') as fp:
        fp.write(json.dumps(json_obj, indent=4))
    return True
