# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import json
import sys
from commonlog import Logger

LOGGER = Logger().getinstance(sys.argv[0])


def get_node_ips():
    """
    功能说明:获取节点IP信息
    :return:
    """
    nodes_file = "/opt/oss/manager/etc/sysconf/nodelists.json"
    # 样例：{'OMP': {'X.X.X.X': ['maintenance']}}
    node_ips = []
    try:
        with open(nodes_file, 'r', encoding='utf-8') as r_stream:
            node_list = json.load(r_stream)
            sorted_list = sorted(node_list.get('nodeList').items(), key=lambda d: int(d[0]))
        for node_info in sorted_list:
            node_ips.append({x.get('IP'): x.get('usage') for x in node_info[1].get('IPAddresses')})
    except Exception as e:
        LOGGER.error("Exception: %s." % e)
        LOGGER.error("Failed to obtain the IP address list of all nodes.")
    return node_ips


def query_arb_ip(arb_ip_list):
    """
    功能说明:查询仲裁ip地址
    :param arb_ip_list:
    :return:
    """
    node_ips = get_node_ips()
    # 3 节点 a.单管(广义上,仲裁部署在0号节点,处理上同单管) b.非单管（广义上,仲裁部署不在0号节点上,处理上同单管）
    # 5 节点 a.非单管

    product_deploy_type = 'NCE-X'

    # 仲裁IP和0号节点IP地址取交集，有交集判定生效
    if len(arb_ip_list) == 3 and [x for x in arb_ip_list if x in node_ips[0].keys()]:
        product_deploy_type = 'NCE-NMS'

    # arb_used_ip
    # arb_inner_ip
    arb_used_ip = []
    arb_inner_ip = []
    node_id_list = list(range(1, len(node_ips)))
    node_id_list.append(0)
    for node_id in node_id_list:
        for one_node_ip in arb_ip_list:
            if one_node_ip in node_ips[node_id].keys():
                arb_used_ip.append(one_node_ip)
                arb_inner_ip.extend([one_ip for one_ip in node_ips[node_id]
                                     if 'maintenance' in node_ips[node_id][one_ip]])
    return True, "%s;%s;INNER_IP;%s" % (product_deploy_type, ','.join(arb_used_ip), ','.join(arb_inner_ip))


def deal_ips(ips):
    """
    功能说明:处理IP地址
    """
    if '.' in ips:
        # ipv4
        ips = [x.split(':')[0] for x in ips.split(',')]
    else:
        ips = '%s,' % ips.replace('[', '').replace(']', '')
        # ipv6
        split_str = ':%s,' % ips.split(',')[-2].split(':')[-1]
        ips = ips.split(split_str)
        if '' in ips:
            ips.remove('')
    return ips


def main(argv):
    arb_ips = argv[1]
    site_name = argv[2]
    LOGGER.info("[query_arb_ip] Query arb ip.")
    if arb_ips == "":
        LOGGER.error("[query_arb_ip] Arb ip: None, arb_ips is None.")
        print("")
        return
    arb_ip = deal_ips(arb_ips)
    result, data = query_arb_ip(arb_ip)
    if result:
        print("site_info;%s;site_name;%s;arb_ip;%s" % (data, site_name, ','.join(arb_ip)))
    else:
        print("")


if __name__ == '__main__':
    main(sys.argv)
