#!/bin/bash

BASE_DIR=$(cd $(dirname $0);pwd)
timeStamp=`date "+%Y%m%d%H%M%S"`
tmpscript="${BASE_DIR}/check_sftp_pwd_$timeStamp.exp"
sftp_user=ftpuser
read sftp_ip
read sftp_pwd

cat >> "$tmpscript" <<SCRIPT
#!expect
set timeout 30
spawn sftp ${sftp_user}@${sftp_ip}
expect {
"*yes/no*" {
    send "yes\r"
    exp_continue
}
"*@${sftp_ip}*" {
    send "$sftp_pwd\r"
}
"*assword:" {
    send "$sftp_pwd\r"
}
}
expect {
"sftp>" {
    exit 0
}
"*assword:" {
    exit 1
}
}


expect "100%"
expect timeout {
    exit 1
}
SCRIPT

buffer="$(expect "$tmpscript")"
if [ $? -ne 0 ];then
  rm -rf $tmpscript
  exit 1
fi
rm -rf $tmpscript
exit 0


