#!/bin/bash
###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
# File name: getrclocalfile.sh
# Description: 获取rc.local文件路径
###############################################################################

LOCAL_PATH="/etc/rc.local"

SCRIPT_NAME="$(basename $0)"
MODULE_NAME="$(echo ${SCRIPT_NAME} | sed 's/\.sh//g')"
RELATIVE_PATH="$(dirname $0)"
#get absolute path
cd "${RELATIVE_PATH}"
ABSOLUTELY_PATH=$(pwd)


#import common variable..
. ./common.inc
. ./error_code.inc
cd - >/dev/null 2>&1

#======================================
# main
#--------------------------------------
function fn_main() {
    PRINT_LOG "INFO" "Execute cmd to getrclocalfile." &>/dev/null
    if [ -f ${LOCAL_PATH} ]
    then
        PRINT_LOG "INFO" "The ${LOCAL_PATH} exist." &>/dev/null
        echo "${LOCAL_PATH}"
		return 0
    else
        PRINT_LOG "FATAL" "The ${LOCAL_PATH} does not exist." &>/dev/null
		echo ""
		return 1
    fi
}
#======================================

PRINT_LOG "INFO" "====================================================================" &>/dev/null
PRINT_LOG "INFO" "bash ${ABSOLUTELY_PATH}/${SCRIPT_NAME}" &>/dev/null
fn_main 
RET_MAIN=$?
PRINT_LOG "INFO" "The result: ret=${RET_MAIN}" &>/dev/null
record_syslog "${RET_MAIN}" "${SCRIPT_NAME}"
exit ${RET_MAIN}
