#!/bin/bash
logger -t $USER -p local0.info "${OPERIP:-127.0.0.1};Start osconfig install.sh script"
#get absolute path
FileName="`basename $0`"
RELATIVE_PATH="$(dirname $0)"
cd "${RELATIVE_PATH}"
ABSOLUTELY_PATH=`pwd`
cd - &> /dev/null

USER=`whoami`
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
[ -z "${WORK_USER}" ] && WORK_USER='ossadm'
if [ "${USER}" = "ossadm"  -o "${USER}" = "admrunuser" ]
then
    echo > /dev/null
else
    echo "Only ossadm or admrunuser can run this command."
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Only ossadm or admrunuser can run this command."
    exit 1
fi

function fn_restore_perm()
{
    cat "${ABSOLUTELY_PATH}/logs/install_osconfig.log" >> "${ABSOLUTELY_PATH}/logs/install.log" 2> /dev/null
    if [ "${WORK_USER}" != "${USER}" ]
    then
        sudo -u "${WORK_USER}" rm -f "${ABSOLUTELY_PATH}/logs/install_osconfig.log"
    else
        rm -f "${ABSOLUTELY_PATH}/logs/install_osconfig.log"
    fi

    find "${ABSOLUTELY_PATH}/logs" -type f -exec chmod 640 {} + &>/dev/null
    chmod 750  "${ABSOLUTELY_PATH}/logs/tmp" 2> /dev/null
    chmod 750  "${ABSOLUTELY_PATH}/logs"    2> /dev/null
    return 0
}

function fn_main()
{
    local param_num=$#
    local all_param="$@"
    local i
    local sudobinpath

    for((i=1; i<=param_num; i++))
    do
        [[ "${1}" == "-sudobinpath" ]] && { sudobinpath=${2}; shift 2; continue; }
    done

    if [ ! -d "${ABSOLUTELY_PATH}/logs" ]
    then
        mkdir  "${ABSOLUTELY_PATH}/logs";
        mkdir  "${ABSOLUTELY_PATH}/logs/tmp";
    fi
    chmod 750 "${ABSOLUTELY_PATH}/logs";
    chmod 750 "${ABSOLUTELY_PATH}/logs/tmp";

    if [ -z "${sudobinpath}" -o ! -d "${sudobinpath}" ]
    then
        echo "Usage: bash install.sh -sudobinpath /usr/local/uniepsudobin"
        logger -t $USER -p local0.err "Usage: bash install.sh -sudobinpath /usr/local/uniepsudobin"
        return 1
    fi

    if [ "${USER}" != "${WORK_USER}" ]
    then
        chmod 440 "${ABSOLUTELY_PATH}/common.inc"
        sudo -u "${WORK_USER}" bash "${ABSOLUTELY_PATH}/install_osconfig.sh" ${all_param}
    else
        bash "${ABSOLUTELY_PATH}/install_osconfig.sh" ${all_param}
    fi
    ret=$?

    return "$ret"
}

fn_main "$@"
RET_MAIN=$?
fn_restore_perm
logger -t $USER -p local0.info "${OPERIP:-127.0.0.1};End to osconfig install.sh script"
exit ${RET_MAIN}
