#!/bin/bash
###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
# File name: configosparams.sh
# Description: 配置操作系统参数入口
###############################################################################
SCRIPT_NAME="$(basename $0)"
MODULE_NAME="$(echo ${SCRIPT_NAME} | sed 's/\.sh//g')"
RELATIVE_PATH="$(dirname $0)"

#get absolute path
cd "${RELATIVE_PATH}"
ABSOLUTELY_PATH=$(pwd)
#import common variable..
. ./common.inc
. ./error_code.inc
cd - >/dev/null 2>&1

#======================================
# main
#--------------------------------------
function fn_main() {
    PRINT_LOG "INFO" "Execute cmd to configosparams." &>/dev/null
    if [ $# -ne 1 -a $# -ne 2 ]; then
        PRINT_LOG "FATAL" "Usage: bash ${SCRIPT_NAME} [mode] or [mode] [version]"
        return 1
    fi

    local mode="$1"
    PRINT_LOG "INFO" "begin to configosparams to: ${mode}" &>/dev/null
    if [ "${mode}" != "install" ] && [ "${mode}" != "upgrade" ] && [ "${mode}" != "rollback" ]; then
        echo "The parameter [mode]<${mode}> is invalid, should be install or upgrade or rollback."
        return 1
    fi

    PRINT_LOG "INFO" "Start to config os users" &>/dev/null
    local ostype=$(bash /usr/local/osconfig/os/bin/getostype.sh)
    PRINT_LOG "INFO" "The ostype is ${ostype}" &>/dev/null
    sudo "${SUDOBIN_PATH}/os/${ostype}/shscripts/configosparams_sudo.sh" "$@" &>${TMP_CONTENT_FILE}
    local retcode=$?
    if [ ${retcode} -ne 0 ]; then
        PRINT_LOG "INFO" "configosparams failed, retcode=${retcode}."
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &>/dev/null
        return ${retcode}
    fi

    PRINT_LOG "INFO" "configosparams success."
    return 0
}

PRINT_LOG "INFO" "====================================================================" &>/dev/null
PRINT_LOG "INFO" "bash ${ABSOLUTELY_PATH}/${SCRIPT_NAME}" &>/dev/null
fn_main $@
RET_MAIN=$?
PRINT_LOG "INFO" "The result: ret=${RET_MAIN}" &>/dev/null
record_syslog "${RET_MAIN}" "${SCRIPT_NAME}"
exit ${RET_MAIN}
