#!/bin/bash

. ./arbitration_opertate_lib
. ./public.sh
env_ips=$(get_current_ips)

NTP_SERVER_IP=""
NTP_SERVER_IP_1=""
all_arbitration_nodes=""

IS_LOCAL_NTP="false"
IS_NTP_CONFIG="false"
#######################################################
#
#
#   create_check_file方法进行配置失败的判定
#   配置失败则立即$（create_check_file 255）
#   告知检查的进程，否则则在所有校验完成后
#   $（create_check_file 100）告知检查进程安装成功
#
#
########################################################

#######################################################
#
#
#       初始化变量
#
#
#
########################################################
function init()
{
    all_arbitration_nodes="$1"
    NTP_SERVER_IP="$2"
    NTP_SERVER_IP_1="$3"

    #获取当前节点角色，是否为NTP服务器
    if [ -z ${NTP_SERVER_IP} ]
    then
        arbitration_log ERROR "CONFIG_NTP" "Ntp server is not filled out"
        $(create_check_file 255)
        exit 1
    fi
}

#停止ntp服务器，修改/etc/ntp.conf文件
function clear_ntp_conf()
{
    arbitration_log INFO "CONFIG_NTP" "Start clear ntp conf."
    bash ./common_ntp.sh -cmd clear_server
    if [ $? -ne 0 ]
    then
        arbitration_log ERROR "CONFIG_NTP" "clear ntp server failed"
        $(create_check_file 255)
        exit 1
    fi
    bash ./common_ntp.sh -cmd stop
    if [ $? -ne 0 ]
    then
        arbitration_log ERROR "CONFIG_NTP" "stop ntp failed"
        $(create_check_file 255)
        exit 1
    fi
}


#####################################################
#
#
#   配置ntp服务器
#   若本地为其中一个ntp服务器
#   设置本地时间可以作为NTP服务器
#   其他情况的NTP服务器节点则将其设为ntp服务器
#   若本地为NTP服务则直接在start_ntp_service进行校验
#
######################################################
function config_ntp()
{
    bash ./common_ntp.sh -cmd add_server -active ${NTP_SERVER_IP} -standby ${NTP_SERVER_IP_1}
    if [ $? -ne 0 ]
    then
        arbitration_log ERROR "CONFIG_NTP" "add ntp server failed"
        $(create_check_file 255)
        exit 1
    fi
}

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_config_ntp_result.sh"
}

function check_ntp_config()
{
    #
    #如果仲裁节点中一个节点是ntp服务器，需要一直尝试校验ntp服务是否正常
    #如果是仲裁节点外节点，只需要校验一次
    #
    check_ntp_result="ERROR"
    #非ntpserver节点
    retry_time=90
    while (($retry_time > 0))
    do
        #防止节点的ntp服务被拉起，导致ntpdate命令执行失败
        bash ./common_ntp.sh -cmd stop
        #多个ntp服务器进行ntpdate，每次若ntpdate成功则成功退出此检查，否则对下一ntp服务器进行ntpdate
        ntpdate ${NTP_SERVER_IP} >/dev/null 2>&1
        if [[ $? == "0" ]]
        then
            check_ntp_result="OK"
            break
        else
            if [ -z ${NTP_SERVER_IP_1} ]
            then
                arbitration_log INFO "CONFIG_NTP" "NTP_SERVER_IP_1 is null. can't ntpdate"
            else
                ntpdate ${NTP_SERVER_IP_1} >/dev/null 2>&1
                if [[ $? == "0" ]]
                then
                    check_ntp_result="OK"
                    break
                fi
            fi
        fi
        ((retry_time--))
        arbitration_log DEBUG "CONFIG_NTP" "Waitting 10s for check ntp server."
        sleep 10
    done

    #非ntpserver节点如果check失败，则配置失败
    #ntpserver节点在start_ntp_service中进行判断的
    if [[ ${check_ntp_result} == "ERROR" ]]
    then
        arbitration_log ERROR "CONFIG_NTP" "Config ntp failed."
        $(create_check_file 255)
        exit
    fi

    arbitration_log INFO "CONFIG_NTP" "Config ntp successfully."
}

function start_ntp_service()
{
    arbitration_log DEBUG "CONFIG_NTP" "Restart ntp service."
    bash ./common_ntp.sh -cmd enable
    bash ./common_ntp.sh -cmd restart
}

function config_ssh_listen()
{
    bash config_ssh_listen.sh refresh || return 1
}

function main()
{
    rm -f /opt/arbitration_file/check_config_ntp_result.sh
    ls /opt/arbitration_file/new >/dev/null 2>&1
    # 全新安装场景才配置NTP；非全新安装场景，不需要配置NTP，仅检查仲裁节点的时间差
    if [ $? -ne 0 ];then
        echo "This environment has already installed arbitration software. Skip config ntp."
        $(create_check_file 100)
        hwclock -w
        return 0
    else
        echo "This environment has not installed arbitration software. Start to config ntp."
    fi
    cp /etc/ntp.conf /etc/ntp.conf_for_arbitration
    init $@
    #不管是否配置ntp服务器都去检查是否和上级NTP服务器同步
    clear_ntp_conf
    config_ntp
    check_ntp_config
    start_ntp_service
    config_ssh_listen
    $(create_check_file 100)
    hwclock -w
}

main $@