#!/bin/bash

#################################################
#
# 获取当前环境使用的NTP的类型
# return
#   0 --- ntpd
#   1 --- chronydd
#
#################################################
function _get_ntp_type()
{
    if [ -f ./ntpType ]
    then
        grep chronyd ./ntpType &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "ntp type: chronyd"
            return 1
        fi
        grep ntpd ./ntpType &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "ntp type: ntpd"
            return 0
        fi
    fi
    local ntp_flag_file="/opt/oss/share/manager/UniEPAgent/ntpType.flag"
    if [ ! -f "${ntp_flag_file}" ]
    then
        ntp_flag_file="/opt/oss/manager/etc/sysconf/ntpType.flag"
    fi
    if [ -f "${ntp_flag_file}" ]
    then
        su - ossadm -c "grep chrony ${ntp_flag_file}" &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "ntp type: chronyd"
            echo chronyd > ./ntpType
            return 1
        else
            echo "ntp type: ntpd"
            echo ntpd > ./ntpType
            return 0
        fi
    fi

    ls /opt/arbitration_file/new >/dev/null 2>&1
    # 对于三方站点，全新安装场景优先使用chrony，增量安装场景与之前保持一致
    if [ $? -ne 0 ];then
        # 增量安装场景
        systemctl status chronyd | grep -i "active" | grep -i "running" &>/dev/null
        if [ $? -eq 0 ];then
            echo "ntp type: chronyd"
            echo chronyd > ./ntpType
            return 1
        fi
        systemctl status ntpd | grep -i "active" | grep -i "running" &>/dev/null
        if [ $? -eq 0 ];then
            echo "ntp type: ntpd"
            echo ntpd > ./ntpType
            return 0
        fi
    else
        # 全新安装场景
        systemctl is-enabled chronyd | egrep "enabled|disabled" &>/dev/null
        if [ $? -eq 0 ];then
            echo "ntp type: chronyd"
            echo chronyd > ./ntpType
            return 1
        fi
    fi

    echo "ntp type: ntpd"
    echo ntpd > ./ntpType
    return 0
}

function check_ntp_status()
{
    echo "start to check ntp status"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd ntp_status
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd ntp_status
        return $?
    fi
}

function check_ntp_track()
{
    echo "start to check ntp tracking"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd ntp_track
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd ntp_track
        return $?
    fi
}

function check_ntp_status_and_track()
{
    check_ntp_status || return 1
    check_ntp_track || return 1
}

function get_ntp_offset()
{
    _get_ntp_type &>/dev/null
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd offset
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd offset
        return $?
    fi
}

function start_ntp()
{
    echo "start to start ntp"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd start
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd start
        return $?
    fi
}

function stop_ntp()
{
    echo "start to stop ntp"
    bash ./ntpd_util.sh -cmd stop || return $?
    bash ./chronyd_util.sh -cmd stop || return $?
}

function restart_ntp()
{
    echo "start to restart ntp"
    stop_ntp || return $?
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd start
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd start
        return $?
    fi
}

function enable_ntp()
{
    echo "start to enable ntp"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd enable
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd enable
        return $?
    fi
}

function add_server()
{
    echo "start to add server"
    local activeIp=$1
    local standbyIp=$2
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        if [ -f ./ntpd_modify_util.sh ]
        then
            bash ./ntpd_modify_util.sh -cmd add_server -active ${activeIp} -standby ${standbyIp}
            return $?
        else
            echo "add server is not allowed."
            return 1
        fi
    elif [ $? -eq 1 ]
    then
        if [ -f ./chronyd_modify_util.sh ]
        then
            bash ./chronyd_modify_util.sh -cmd add_server -active ${activeIp} -standby ${standbyIp}
            return $?
        else
            echo "add server is not allowed."
            return 1
        fi
    fi
}

function clear_server()
{
    echo "start to clear server"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        if [ -f ./ntpd_modify_util.sh ]
        then
            bash ./ntpd_modify_util.sh -cmd clear_server
            return $?
        else
            echo "clear server is not allowed."
            return 1
        fi
    elif [ $? -eq 1 ]
    then
        if [ -f ./chronyd_modify_util.sh ]
        then
            bash ./chronyd_modify_util.sh -cmd clear_server
            return $?
        else
            echo "clear server is not allowed."
            return 1
        fi
    fi
}

function backup()
{
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_modify_util.sh -cmd backup
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_modify_util.sh -cmd backup
        return $?
    fi
}

function using_server()
{
    check_ntp_status_and_track &>/dev/null || return 1
    _get_ntp_type &>/dev/null
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd using_server
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd using_server
        return $?
    fi
}

function main()
{
    for i in {1..3}
    do
        [[ ${1#-} == "cmd" ]] && { cmd=$2; shift 2; }
        [[ ${1#-} == "active" ]] && { active=$2; shift 2; }
        [[ ${1#-} == "standby" ]] && { standby=$2; shift 2; }
    done
    case ${cmd} in
    "ntp_status") check_ntp_status;;
    "ntp_track") check_ntp_track;;
    "ntp_status_track") check_ntp_status_and_track;;
    "offset") get_ntp_offset;;
    "start") start_ntp;;
    "stop") stop_ntp;;
    "restart") restart_ntp;;
    "enable") enable_ntp;;
    "add_server") add_server ${active} ${standby};;
    "clear_server") clear_server;;
    "backup") backup;;
    "using_server") using_server;;
    "get_ntp_type") _get_ntp_type;;
    *)
        echo "error cmd"
        return 1
        ;;
    esac
}

main $@
exit $?