#! /bin/bash
. ./arbitration_opertate_lib

all_inner_card_ip_list=""
all_access_ip_list=""
NTP_SERVER_IP=""
NTP_SERVER_IP_1=""
###################################################################
#
#
#    初始化参数
#
#
###################################################################
function init()
{
    all_inner_card_ips=$1
    all_access_ips=$2
    master_location_name=$3
    slave_location_name=$4
    NTP_SERVER_IP=$5
    NTP_SERVER_IP_1=$6
    
    all_inner_card_ip_list=(`echo $all_inner_card_ips|tr ',' ' '`)
    all_access_ip_list=(`echo $all_access_ips|tr ',' ' '`) 

}
###################################################################
#
#
#     在前置检查中校验是否和上级ntp同步
#
#
###################################################################
function check_ntpservice_synchronize()
{
    check_ntp_result="ERROR"
    bash ./common_ntp.sh -cmd ntp_status_track
    if [[ $? == 0 ]]
    then
        check_ntp_result="OK"
    fi
    if [[ ${check_ntp_result} == "ERROR" ]]
    then
        echo "The current node ntp service is in an unsynchronized state." >&2
    fi
}

function main()
{
    init $@
    check_ntpservice_synchronize
}

main $@
if [ $? -eq 0 ];then
    create_check_result_file 100 "check_ntp_synchronize_result.sh"
else
    create_check_result_file 255 "check_ntp_synchronize_result.sh"
fi
