#! /bin/bash
. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
env_ips=$(get_current_ips)

third_node_inner_ip=$1
if [[ ${third_node_inner_ip} == "" ]]
then
    arbitration_log ERROR "CHECK INPUT PARAMETER" "third node inner ip is empty."
    exit 0
fi

#记录结果
function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_start_arbitration_result.sh"
}

function modify_monitor_start_script()
{   
    #修改第三方节点的monitor配置
    local real_node_ip=$(get_real_full_ip ${third_node_inner_ip})
    if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
    then
        arbitration_log INFO "MODIFY_MONITOR_FILE" "Modify monitor properties."
        sed -i "s/aam.local.etcdservers=*.*.*.*:2390/aam.local.etcdservers=${third_node_inner_ip}:2390/g" ${MONITOR_HOME}/conf/aam.properties
        sed -i "s/if.*opt\/controller\/naas\/deployment\/deployment.inc.*]/if false /" ${MONITOR_HOME}/script/service.sh
    fi
}

function start_etcd_monitor
{
    #启动前停止服务
    ps -efww | grep -w "Dprocess.name=arbitration-monitor_${INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9
    ps -efww | grep -w "Dprocess.name=arbitration-etcd_${INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9

    #停止服务后等待2秒，确保端口已释放
    sleep 2

    #启动etcd
    sudo -u arbiter bash ${ETCD_HOME}/script/service.sh restart
    if [[ $? == "0" ]]
    then
        arbitration_log INFO "START_ETCD" "Start etcd successfully."
        $(create_check_file 100)
    else
        arbitration_log INFO "START_ETCD" "Start etcd failed."
        $(create_check_file 255)
        exit
    fi
    #启动monitor
    local real_node_ip=$(get_real_full_ip ${third_node_inner_ip})
    if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") = "" ]]
    then
      sudo -u arbiter bash ${MONITOR_HOME}/script/service.sh restart
      if [[ $? == "0" ]]
      then
          arbitration_log INFO "START_ETCD" "Start monitor successfully."
          $(create_check_file 100)
      else
          arbitration_log ERROR "START_ETCD" "Start monitor failed."
          $(create_check_file 255)
      exit
      fi
    fi

}

function main()
{
    rm -f /opt/arbitration_file/check_start_arbitration_result.sh
    modify_monitor_start_script
    start_etcd_monitor
}

main