#!/bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
env_ips=$(get_current_ips)

all_arbitration_nodes_ip=$1
all_arbitration_nodes_list=""
host_name=""
localip=""
hostip=""
hostedip=""

function clean_crontab()
{
    aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')
    if [[ -e /etc/SuSE-release ]]
    then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        service cron restart > /dev/null
    elif [[ -e /etc/euleros-release ]]
    then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        systemctl restart crond.service > /dev/null
    else
        if [[ -e /var/spool/cron/root ]]
        then
            sed -i "/${aamonitor_watchdog_path_format}/d" /var/spool/cron/root
        fi
    fi
}


function arbitration_install()
{
    bash ./arbitration_install.sh || return 1
}

function main()
{
    clean_crontab
    arbitration_install || return 1
}

main
if [ $? -eq 0 ];then
    create_check_result_file 100 "check_pre_install_arbitration_result.sh"
else
    create_check_result_file 255 "check_pre_install_arbitration_result.sh"
fi