#!/bin/bash

MODULE_NAME="$(basename $0)"

GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}

wirteFailedResultFile()
{
    echo "#!/bin/bash
echo  RESULT:255   
   ">"$set_network_info_result"
 
}

wirteInitialResultFile()
{
    echo "#!/bin/bash
echo  RESULT:0   
   ">"$set_network_info_result"
 
}

wirteSuccessResultFile()
{
    echo "#!/bin/bash
echo  RESULT:100   
   ">"$set_network_info_result"
 
}

Main()
{
    # current path   
    GetWorkPath
    
    set_network_info_result="$curPath/check_set_network_info_res.sh"
    
    wirteInitialResultFile

    nodes_NCE_json=$1
    if [ ! -f "$nodes_NCE_json" ];then
        wirteFailedResultFile
        return 1
    fi

    product_NCE_json=$2
    if [ ! -f "$product_NCE_json" ];then
        wirteFailedResultFile
        return 1
    fi

    networkinfo_NCE_json=$3
    if [ ! -f "$networkinfo_NCE_json" ];then
        wirteFailedResultFile
        return 1
    fi

    bash /opt/oss/manager/tools/resmgr/setproductinfo.sh -nodes "$nodes_NCE_json" -product "$product_NCE_json" -networkinfo "$networkinfo_NCE_json" >> "$curPath"/${MODULE_NAME}.log
    if [ $? -ne 0 ];then
       wirteFailedResultFile
       return 1
    fi

    wirteSuccessResultFile
    return 0
   
}

Main $*
exit $?