#!/bin/bash

function main
{
    confs=(`echo $1 | awk -F';' '{for( i=1;i<NF+1; i++ ) print $i}'`)
    len=${#confs[@]}
    result=0
    if [[ $len > 0 ]]
    then
        for ((i=0; i<$len; i++));do
            values_i=(`echo ${confs[i]} | awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}'`)
            bond_name_i=${values_i[0]}
            first_bus_info=""
            second_bus_info=""
            if [[ "${bond_name_i}X" == "X" ]]
            then
                echo "parameter err." >&2
                exit 1
            fi
            first_netcard_i=${values_i[1]}
            if [[ "${first_netcard_i}X" == "X" ]]
            then
                echo "parameter err." >&2
                exit 1
            fi
            ifconfig $first_netcard_i 2>/dev/null |grep HWaddr > /dev/null
            if [[ $? != 0 ]]
            then
                echo "$first_netcard_i is not exist!" >&2
                result=1
            else
                first_bus_info=(`ethtool -i $first_netcard_i | awk -F':' '{if($1~/bus-info/) print $3}'`)
            fi
            second_netcard_i=${values_i[2]}
            if [[ "${second_netcard_i}X" == "X" ]]
            then
                echo "parameter err." >&2
                exit 1
            fi
            ifconfig $second_netcard_i 2>/dev/null |grep HWaddr > /dev/null
            if [[ $? != 0 ]]
            then
                echo "$second_netcard_i is not exist!" >&2
                result=1
            else 
                second_bus_info=(`ethtool -i $second_netcard_i | awk -F':' '{if($1~/bus-info/) print $3}'`)            
            fi
            if [[ $first_netcard_i == $second_netcard_i ]]
            then
                echo "The netcards of $bond_name_i are the same,must be different!" >&2
                result=1
            else 
                if [[ $first_bus_info != "" ]] && [[ $second_bus_info != "" ]] && [[ $first_bus_info == $second_bus_info ]]
                then
                    echo "The $first_netcard_i and $second_netcard_i of $bond_name_i are in the same NIC,should be in different NIC!" >&2
                    result=1
                fi
            fi
            

            for ((j=i+1; j<$len; j++));do
                values_j=(`echo ${confs[j]} | awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}'`)
                bond_name_j=${values_j[0]}
                if [[ "${bond_name_j}X" == "X" ]]
                then
                    echo "parameter err." >&2
                    exit 1
                fi
                first_netcard_j=${values_j[1]}
                if [[ "${first_netcard_j}X" == "X" ]]
                then
                    echo "parameter err." >&2
                    exit 1
                fi
                second_netcard_j=${values_j[2]}
                if [[ "${second_netcard_j}X" == "X" ]]
                then
                    echo "parameter err." >&2
                    exit 1
                fi

                if [[ $bond_name_i == $bond_name_j ]]
                then
                    if [[ $first_netcard_i != $first_netcard_j ]] || [[ $second_netcard_i != $second_netcard_j ]]
                    then
                        echo "The netcards of ${bond_name_i} is not same!" >&2
                        result=1
                    fi
                else
                    if [[ $first_netcard_i == $first_netcard_j ]] || [[ $first_netcard_i == $second_netcard_j ]] || [[ $second_netcard_i == $first_netcard_j ]] || [[ $second_netcard_i == $second_netcard_j ]]
                    then
                        echo "The netcards of ${bond_name_i} and ${bond_name_j} is conflict!" >&2
                        result=1
                    fi
                fi
            done
        done
    fi
    if [[ $result == 0 ]]
    then
        echo "Check bond parameters success!" >&1
    fi
    exit $result
}

main $*