#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalIP.sh
# Version:Data          : 
# Description           : modifty /etc/sysconfig/network/ifcfg-X
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"

#get absolute path
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
#import common variable..
. ../common/error_code.inc
. ../common/common.inc
cd - >/dev/null 2>&1


# Name        : fn_clean_tmp_file
# Description : Clear temporary files and directories in the installation process
function fn_remove_tmp_file()
{
    [ -d "${TMP_CONFIG_PATH}" ] && rm -rf "${TMP_CONFIG_PATH}"/tmp*
    return 0
}


# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value
function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi
    
    if [ "${RETCODE}" = 0 ]
    then
        echo "`date` `hostname` `whoami` setLocalRoutev6_fc.sh;Successful;Set route Successfully." >> /var/log/localmessages
        echo "Set route Successfully. "
    else
        echo "`date` `hostname` `whoami` setLocalRoutev6_fc.sh;Failed;Set route Failed." >> /var/log/localmessages
        echo "Set route Failed."
    fi    
    chmod 640 /var/log/localmessages

    return 0
}


# Name        : fn_check_or_modify_routecfg
# Description : check ifcfg-eth-X
# Parameters  : $1 ifcfg-eth-X
function fn_check_or_modify_routecfg()
{
    local ROUTECFG_FILE=$1

    grep -w 'IPADDR' "${ROUTECFG_FILE}" > /dev/null 2>&1 || echo "IPV6ADDR=''" >> "${ROUTECFG_FILE}" 
    grep -w 'NETWORK' "${ROUTECFG_FILE}" > /dev/null 2>&1 || echo "NETWORK=''" >> "${ROUTECFG_FILE}" 
    grep -w 'BOOTPROTO' "${ROUTECFG_FILE}" > /dev/null 2>&1 || echo "BOOTPROTO='static'" >> "${ROUTECFG_FILE}" 
    return 0
}


# Name        : fn_get_config
# Description : get the config from osmu
# Parameters  : $1 properties file
function fn_get_config()
{
    local TMP_CONFIG_FILE=$1
    local NIC_DEVICE
    local DESTIP
    local PREFIX
    local GATEWAY
    cat $TMP_CONFIG_FILE
    NIC_DEVICE=`fn_get_value "${TMP_CONFIG_FILE}" "REF_NIC_DEVICE"`
    DESTIP=`fn_get_value "${TMP_CONFIG_FILE}" "REF_DESTIP"`
    PREFIX=`fn_get_value "${TMP_CONFIG_FILE}" "REF_PREFIX"`
    GATEWAY=`fn_get_value "${TMP_CONFIG_FILE}" "REF_GATEWAY"`
    echo "get config file: NIC_DEVICE=${NIC_DEVICE}"
    echo "get config file: DESTIP=${DESTIP}"
    echo "get config file: PREFIX=${PREFIX}"
    echo "get config file: GATEWAY=${GATEWAY}"

    
    if [ -z "${NIC_DEVICE}" ] ||  [ -z "${DESTIP}" ] || [ -z "${PREFIX}" ]
    then
        PRINT_LOG "FATAL" "The param NIC_DEVICE<${NIC_DEVICE}>,DESTIP<${DESTIP}>,PREFIX<${PREFIX}>could not found!"
        return "${ERROR_PARAM}"
    fi
    
    fn_validate_ipv6 "${DESTIP}" || return $?
    fn_validate_ipv6_prefix "${PREFIX}" || return $?
    

    eval $2="${NIC_DEVICE}"
    eval $3="${DESTIP}"
    eval $4="${PREFIX}"
    eval $5="${GATEWAY}"

    return 0
}

# Name        : fn_modify_ROUTECFG_FILE
# Description : modify ifcfg-eth-X
# Parameters  : $1 ifcfg-eth-X
# Parameter   : $2 network card mac address
# Parameter   : $3 pci bus id
function fn_modify_ROUTECFG_FILE()
{
    local routefile=$1
    local destip=$2
    local prefix=$3
    local gateway=$4
    local card_name=$5
    # 修改ifcfg-eth-X文件。
    cat ${routefile} | grep "${destip}\/${prefix}"
    if [ $? -eq 0 ]
    then
        sed -i "/${destip}\/${prefix}.*/d" ${routefile}
    fi
    echo "${destip}/${prefix} via ${gateway} dev ${card_name}" >> "${routefile}" 2>&1
    if [ $? -ne 0 ]
    then
        PRINT_LOG  "FATAL" "Set ${ROUTECFG_FILE} configuration file ...failed"
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        return ${ERR_EXECSYS}
    fi
    
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
    PRINT_LOG  "INFO" "Set ${ROUTECFG_FILE} configuration file ...OK"
    
    return 0 
}

function fn_main()
{
    local REF_NIC_DEVICE
    local REF_DESTIP
    local REF_PREFIX
    local REF_OS_TYPE
    local REF_GATEWAY
    local network_card_name
    local NETWORK_CARD_NAME
    local HW_ADDR
    local BUS_PCI
    local ROUTECFG_FILE
    
    PRINT_LOG "INFO" "bash $0 $1"
    if [ $# -lt 1 ]
    then
        PRINT_LOG "FATAL" "Usage: $0 <config file>"
        PRINT_LOG "FATAL" "e.g:      $0 /opt/osmu/script/properties/sample.properties"
        fn_check_status "${ERROR_PARAM}"
    fi
    
    CONFIG_FILE=`echo "$1" | sed 's/\\\/\//g'`
    
    sed -i "s/[[:space:]]*$//g" "${CONFIG_FILE}"
    fn_check_config_file "${CONFIG_FILE}" || return $?

    fn_get_config "${TMP_CONFIG_FILE}" REF_NIC_DEVICE REF_DESTIP REF_PREFIX REF_GATEWAY
    echo "REF_NIC_DEVICE=${REF_NIC_DEVICE}"
    echo "REF_DESTIP=${REF_DESTIP}"
    echo "REF_PREFIX=${REF_PREFIX}"
    echo "REF_GATEWAY=${REF_GATEWAY}"

    if [ $? -ne 0 ]
    then
        return "${ERROR_PARAM}"
    fi
    
    ## 取得网卡总线号
    BUS_PCI="`ethtool -i ${REF_NIC_DEVICE} 2> /dev/null | grep 'bus-info' | cut -d ' ' -f 2`"
    ## 取得总线号对应网卡的说明 
    [ -z "${BUS_PCI}" ] || network_card_name=`lspci -v 2> /dev/null | awk -v 'RS=' '/'"${BUS_PCI#*:}"'/ {print $0}' | egrep -i "\<Subsystem: "`
    NETWORK_CARD_NAME=${network_card_name#*Subsystem:}
    ## 取得MAC地址
    HW_ADDR="`ifconfig ${REF_NIC_DEVICE} |awk -F 'ddr ' '/\<HWaddr / {print $2}' | tr [A-Z] [a-z] | xargs`"
    CFG_DIR="/etc/sysconfig/network-scripts"
    CFG_FILE_NAME="route6-${REF_NIC_DEVICE}"
    ROUTECFG_FILE="${CFG_DIR}/${CFG_FILE_NAME}"
    ROUTECFG_BAK_DIR="/etc/sysconfig/network-scripts/OLD_ROUTECFG_BAK"
    
    [ -f "${ROUTECFG_BAK_DIR}" ] || mkdir -p "${ROUTECFG_BAK_DIR}"

    ## 检查网卡对应的配置文件是否存在
    if [ ! -f "${ROUTECFG_FILE}" ]
    then
        PRINT_LOG "WARN" "${ROUTECFG_FILE} does not exist"
        echo "${REF_DESTIP}/${REF_PREFIX} via ${REF_GATEWAY} dev ${REF_NIC_DEVICE}" >> "${ROUTECFG_FILE}"
        PRINT_LOG "INFO" "Generate ${ROUTECFG_FILE} file success"
    else
        #备份一份原始配置文件
        [ -f "${ROUTECFG_BAK_DIR}/${CFG_FILE_NAME}.bak" ] && cp -a "${ROUTECFG_FILE}" "${ROUTECFG_BAK_DIR}/${CFG_FILE_NAME}.$$.bak"
        cp -a "${ROUTECFG_FILE}" "${ROUTECFG_BAK_DIR}/${CFG_FILE_NAME}.bak"
        
        #修改配置文件
        fn_modify_ROUTECFG_FILE "${ROUTECFG_FILE}" "${REF_DESTIP}" "${REF_PREFIX}" "${REF_GATEWAY}" "${REF_NIC_DEVICE}"
        if [ $? -ne 0 ]
        then
            mv -f "${ROUTECFG_BAK_DIR}/${CFG_FILE_NAME}.bak" "${ROUTECFG_FILE}"
            return ${ERR_EXECSYS}
        fi
    fi

    #修改完成后重新启动网卡使配置文件生效。
    systemctl restart network > "${TMP_CONTENT_FILE}" 2>&1
    if [ $? -ne 0 ]
    then
        PRINT_LOG "WARN" "Excute<systemctl restart \"${REF_NIC_DEVICE}\"> ...failure"
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        return ${ERR_EXECSYS}
    fi
    PRINT_LOG "WARN" "Excute<systemctl restart \"${REF_NIC_DEVICE}\"> ...OK"
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
    
    
    return ${SUCCESS_CODE};
}

#=======================================================================
fn_main "$@"
ret=$?
fn_write_operation_log ${ret}
FUNC_CLEAN_TMP_FILE
exit ${ret}
#=======================================================================
