#!/bin/bash
# 替换json文件中的ip地址
cd /opt/install
#productname
product_name=NCE

product_version=V100R022C00

#遍历入参键值对,进行逐一替换

for keyvalue in $*
do
    #以“=”拆分每一个参数
    OLD_IFS=$IFS
    IFS='='
    keyvalue_arry=($keyvalue)
    key=${keyvalue_arry[0]}
    value=${keyvalue_arry[1]}
    IFS=$OLD_IFS

    #替换模板json文件中的key为相应的value

    sed -i "s/\${$key}/$value/g" input.json
    sed -i "s/\${$key}/$value/g" nodes_NCE.json
    sed -i "s/\${$key}/$value/g" networkinfo_NCE.json
    sed -i "s/\${$key}/$value/g" product_NCE.json
    sed -i "s/\${$key}/$value/g" networkinfo_OMP.json > /dev/null 2>& 1

done

#替换product_name
sed -i "s/\${product_name}/${product_name}/g" input.json
sed -i "s/\${product_name}/${product_name}/g" nodes_NCE.json
sed -i "s/\${product_name}/${product_name}/g" networkinfo_NCE.json
sed -i "s/\${product_name}/${product_name}/g" product_NCE.json
sed -i "s/\${product_name}/${product_name}/g" networkinfo_OMP.json > /dev/null 2>& 1

#替换product_version
sed -i "s/\${product_version}/${product_version}/g" input.json
sed -i "s/\${product_version}/${product_version}/g" nodes_NCE.json
sed -i "s/\${product_version}/${product_version}/g" networkinfo_NCE.json
sed -i "s/\${product_version}/${product_version}/g" product_NCE.json
sed -i "s/\${product_version}/${product_version}/g" networkinfo_OMP.json > /dev/null 2>& 1

sh remove_empty_node.sh nodes_NCE.json

#处理networkinfo_NCE.json文件，使得网卡名称一样的用途合一
if [ -f "handle_networkinfo.py" ];then
    python handle_networkinfo.py networkinfo_NCE.json
    python handle_networkinfo.py networkinfo_OMP.json
elif [ -f "handle_networkinfo.pyc" ];then
    python handle_networkinfo.pyc networkinfo_NCE.json
    python handle_networkinfo.pyc networkinfo_OMP.json
else
    echo "Warnning:handle_networkinfo file does not exist."
fi

exit $?