#!/bin/bash
. ./controller.inc
function check_file_system
{
    local path_list=("/opt")
    for path in ${path_list[@]}
    do
        if [ -d $path ]; then 
			print_log "INFO" "Checking file system type of $path."
            local file_system=`df -T $path 2>/dev/null | tail -1 | awk '{print $2}'`
            if [ $? -eq 0 ] && [ "${file_system}X" == "ext3X" -o "${file_system}X" == "ext4X" -o "${file_system}X" == "xfsX" ]; then
				print_log "INFO" "File system check successfully. The file system type of $path is ${file_system}."
            else
				print_log "ERROR" "The file system type of $path is recommend to be ext3/ext4 , but the current type is $file_system."
                return 1
            fi
        fi
    done
    return 0
}