#!/bin/bash

function LOG()
{
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "`date +%Y`-`date +%m`-`date +%d` `date +%H`:`date +%M`:`date +%S` ${Level} $2"
}

wirteFailedResultFile()
{
    echo "RESULT:255">"$backup_server_data"
 
}

wirteInitialResultFile()
{
    echo "RESULT:0">"$backup_server_data"
    chmod 640 $backup_server_data
 
}

wirteSuccessResultFile()
{
    echo "RESULT:100">"$backup_server_data"
 
}


Main()
{
     product_name=$1
     product_version=$2
     
     LOG "INFO" "backup the initial data product_name $product_name"
       
     LOG "INFO" "backup the initial data product_version $product_version"
     
     backup_server_data="/opt/backup/backuptmp/backup_initial_data/output/check_backup_data_process_${product_name}.flag"
     
     wirteInitialResultFile
     
     if [ "$product_version" != "" ]
     then
         bash /opt/oss/manager/agent/BackupService/bin/backupDynamicData.sh -product $product_name -remark $product_version
     else
         bash /opt/oss/manager/agent/BackupService/bin/backupDynamicData.sh -product $product_name
     fi
    
     if [ $? -ne 0 ];then
        wirteFailedResultFile
        return 1
     fi
    
     wirteSuccessResultFile
     return 0
}

Main $*
exit $?