root="/mnt/disk"
mkdir -p ${root}/opt/macs/

if [ ! -d /media/macs/ ];then
    devs=`ls /dev/sr*`
    for dev in ${devs}
    do
        mount ${dev} /media/
        if [ -d /media/macs/ ];then
            break
        fi
        sleep 5
        umount /media/
    done
fi

cp -f /media/macs/* ${root}/opt/macs/
function modify_eth()
{
    dos2unix ${root}/opt/macs/*
    macs=""
    eths=$(ls /sys/class/net/ | grep eth | xargs)
    for eth in ${eths}
    do
        mac=$(cat /sys/class/net/${eth}/address)
        macs="${macs} ${mac}"
    done
    echo ${macs}
    for mac in ${macs}
    do
        filename=$(echo ${mac} | sed "s/:/-/g")
        if [ -f ${root}/opt/macs/${filename} ]
        then
            eth=$(cat ${root}/opt/macs/${filename} | grep "NETCARD" | awk -F= '{print $2'})
            vlan=$(cat ${root}/opt/macs/${filename} | grep "VLAN" | awk -F= '{print $2'})
            ipaddr=$(cat ${root}/opt/macs/${filename} | grep "IPADDR" | awk -F= '{print $2'})
            netmask=$(cat ${root}/opt/macs/${filename} | grep "NETMASK" | awk -F= '{print $2'})
            gateway=$(cat ${root}/opt/macs/${filename} | grep "GATEWAY" | awk -F= '{print $2'})
            if [ ${vlan} -gt "1" ];then
                device="${eth}.${vlan}"
            else
                device=${eth}
            fi
            network_file="${root}/etc/sysconfig/network-scripts/ifcfg-${device}"
            
            if [ ! -f ${network_file} ];then
                touch ${network_file}
            fi
            
            grep "BOOTPROTO=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/BOOTPROTO=/d" ${network_file}
            fi
            grep "DEVICE=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/DEVICE=/d" ${network_file}
            fi
            grep "IPADDR=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/IPADDR=/d" ${network_file}
            fi
            grep "NETMASK=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/NETMASK=/d" ${network_file}
            fi
            grep "GATEWAY=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/GATEWAY=/d" ${network_file}
            fi
            grep "ONBOOT=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/ONBOOT=/d" ${network_file}
            fi
            grep "VLAN=" ${network_file} >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sed -i "/VLAN=/d" ${network_file}
            fi
            echo "BOOTPROTO=none" >>${network_file}
            echo "DEVICE=${device}" >>${network_file}
            echo "IPADDR=${ipaddr}" >>${network_file}
            echo "NETMASK=${netmask}" >>${network_file}
            echo "GATEWAY=${gateway}" >>${network_file}
            echo "ONBOOT=yes" >>${network_file}
            if [ ${vlan} -gt "1" ];then
                echo "VLAN=yes" >>${network_file}
            fi
            break
        fi
    done
}
modify_eth
rm -rf ${root}/opt/macs
