#!/bin/bash
# Copyright Huawei Technologies Co., Ltd. 2020-2021. All rights reserved.


function main()
{
    # 检查是否是OMP或NMS_Server节点
    local result=$(cat /etc/uuid/uuid.txt)
    if [ "${result}" -eq 1 ] || [ "${result}" -eq 0 ]
    then
        src_dir=$(dirname $(readlink -f "$0"))
        
        local matrix_path="${src_dir}/iMaster NCE V100R021C10 Communication Matrix.json"
        local list_path="${src_dir}/Test IP List.csv"
        local query_temp=/home/ossadm/queryproduct_temp

        sudo -u ossadm bash -c "rm -f /home/ossadm/PortCheck.csv" >/dev/null 2>&1
        sudo -u ossadm bash -c "rm -rf ${query_temp}" >/dev/null 2>&1
        sudo -u ossadm bash -c "mkdir -p ${query_temp}" >/dev/null 2>&1
        [ -f /opt/oss/manager/tools/resmgr/queryproduct.sh ] && sudo -i -u ossadm bash -c "cd /opt/oss/manager/tools/resmgr;./queryproduct.sh -pn all -output ${query_temp}" > /dev/null
        if [ $? -ne 0 ]
        then
            echo "bash queryproduct.sh failed!"
            exit 1
        fi

        sudo -u ossadm bash -c "chmod 750 -R ${query_temp}"
        local managerip=$(cat /opt/oss/manager/var/agent/managerip.conf | grep "managerip" | awk "NR==1")
        local OMP="${managerip#*=}"
        local OMP_IP="${OMP%,*}"
        sudo -i -u ossadm bash -c "source /opt/oss/manager/bin/engr_profile.sh;cd \"${src_dir}\";python process_data.py* \"${matrix_path}\" \"${list_path}\" \"${query_temp}\"/nodes_NCE.json \"${OMP_IP}\""
        cp -f /home/ossadm/PortCheck.csv "${src_dir}" >/dev/null 2>&1
        sudo -u ossadm bash -c "rm -rf \"${query_temp}\" >/dev/null 2>&1"
    else
        echo "The current node is not OMP or NMS_Server node!"
        exit 1
    fi
}

main
exit $?