#!/bin/bash

function init() {
  base_path=$(cd $(dirname $0);pwd)
  DISK_EXPAND_SCRIPT="${base_path}/disk_expand.sh"
  CONFIG_BACKUP_SERVER_SCRIPT="${base_path}/config_backup_server.sh"
  SUCCESS_FLAG="${base_path}/result.log"
  RUN_EXPAND_SCRIPT_SUCCESS_FLAG="${base_path}/runExpandScriptSuccess.txt"
}

function main() {
  xuser=$(id -un)
  if [ "${xuser}" != "root" ]
  then
  echo "please login as root, then excute the script again."
  exit 1
  fi

  init

  echo "Start to partitioning disk"
  bash "$DISK_EXPAND_SCRIPT"
  disk_expand_result=$?
  if [[ $disk_expand_result -eq 0 ]] || [[ $disk_expand_result -eq 99 && -f $RUN_EXPAND_SCRIPT_SUCCESS_FLAG ]];then
    curtime=`date "+%Y-%m-%d %H:%M:%S"`
    echo "[$curtime] run expand script successful" >> $RUN_EXPAND_SCRIPT_SUCCESS_FLAG
  else
    echo "failed to partitioning disk"
    return 1
  fi
  echo "Partitioning disk successful"

  echo "Start to modify Config Backup Parameters"
  bash "$CONFIG_BACKUP_SERVER_SCRIPT"
  if [ $? -ne 0 ];then
    echo "failed to modify Config Backup Parameters"
    return 2
  fi
  echo "Config backup server information successful"
  echo "Everything is ok"

  curtime=`date "+%Y-%m-%d %H:%M:%S"`
  echo "[${curtime}] Everything is ok" >> "$SUCCESS_FLAG"
  return 0

}

main
exit $?

