#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# File name: stop.sh
# Description: the shell to stop easysuite
ps_result=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
ps_python_result=`ps -ef | grep easysuite/3rdparty | awk '{print $2}'`
user=$(whoami)
if [ "${user}" != "root" ]
then
    echo "The script must be run as the root user."
    exit 1
fi
path=`pwd`
log_path=$path'/var/run/log/easysuite.log'
timestr=`date '+%Y-%m-%d %H:%M:%S'`
if [ -z "${ps_result}" ];then
    echo "no server is running, stop easysuite success."
    exit 0
else
    for i_result in ${ps_result[@]};
    do
        echo "kill pid $i_result"
        kill -9 $i_result
    done

    for i_result in ${ps_python_result[@]};
    do
        echo "kill pid $i_result"
        kill -9 $i_result
    done
    sleep 2
    ps_kill_result=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
    if [ -z "${ps_kill_result}" ]
    then
        echo "stop easysuite success."
        logger -t $USER -p local0.err "stop easysuite successfully." >/dev/null 2>&1 &
        if [ -f "${log_path}" ]
        then
            echo "[$timestr] user $user stop easysuite success." >>$log_path 2>&1
        fi
    else 
        echo "stop easysuite failed."
        logger -t $USER -p local0.err "stop easysuite failed." >/dev/null 2>&1 &
        if [ -f "${log_path}" ]
        then
            echo "[$timestr] user $user stop easysuite failed." >>$log_path 2>&1
        fi
    fi
fi
