#!/bin/bash
# sh handle_networkinfo.sh networkinfo.json

filename=$1
logger_file="handle_networkinfo.log"

date >> ${logger_file}
echo "handle ${filename}." >> ${logger_file}
if [ ! -f "$filename" ];then
    echo "The file ${filename} does not exist." >> ${logger_file}
    exit 1
fi


pypath="/opt/NCEICMR/python"
if [ -d ${pypath} ];then
    unset PYTHONSTARTUP PYTHONHOME
    LD_LIBRARY_PATH=$pypath/lib:${LD_LIBRARY_PATH}
    export LD_LIBRARY_PATH
    PATH=$pypath/lib:${PATH}
    pycmd=$pypath/bin/python
    if [ -f "handle_networkinfo.py" ];then
        $pycmd handle_networkinfo.py ${filename} >> ${logger_file}
    elif [ -f "handle_networkinfo_py3.pyc" ];then
        $pycmd handle_networkinfo_py3.pyc ${filename} >> ${logger_file}
    elif [ -f "handle_networkinfo.pyc" ];then
        $pycmd handle_networkinfo.pyc ${filename} >> ${logger_file}
    else
        echo "Warnning:handle_networkinfo file does not exist." >> ${logger_file}
        exit 1
    fi
else
    command -v python >/dev/null 2>&1
    if [ $? -ne 0 ];then
        if [ -f "handle_networkinfo.py" ];then
            python3 handle_networkinfo.py ${filename} >> ${logger_file}
        elif [ -f "handle_networkinfo_py3.pyc" ];then
            python3 handle_networkinfo_py3.pyc ${filename} >> ${logger_file}
        elif [ -f "handle_networkinfo.pyc" ];then
            python3 handle_networkinfo.pyc ${filename} >> ${logger_file}
        else
            echo "Warnning:handle_networkinfo file does not exist." >> ${logger_file}
            exit 1
        fi
    else
        if [ -f "handle_networkinfo.py" ];then
            python handle_networkinfo.py ${filename} >> ${logger_file}
        elif [ -f "handle_networkinfo_py2.pyc" ];then
            python handle_networkinfo_py2.pyc ${filename} >> ${logger_file}
        elif [ -f "handle_networkinfo.pyc" ];then
            python handle_networkinfo.pyc ${filename} >> ${logger_file}
        else
            echo "Warnning:handle_networkinfo file does not exist." >> ${logger_file}
            exit 1
        fi
    fi
fi

exit $?
