#!/bin/bash
#脚本记录日志
logFile="/var/pre_install/init_env.log"
if [ ! -f ${logFile} ];then
    mkdir -p /var/pre_install
    touch ${logFile} > /dev/null 2>& 1
fi

function LOG()
{
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "`date +%Y`-`date +%m`-`date +%d` `date +%H`:`date +%M`:`date +%S`| ${Level} $2">>${logFile}
}

LOG "INFO" "Prepare install config file"
code=$1
network_info_path=$2
protection=$3
cp -rf /opt/install/NCE*_EasySuite/${code}/product_NCE.json /opt/install
cp -rf /opt/install/NCE*_EasySuite/${code}/${network_info_path}/nodes_NCE.json /opt/install
cp -rf /opt/install/NCE*_EasySuite/${code}/${network_info_path}/input.json /opt/install
cp -rf /opt/install/NCE*_EasySuite/${code}/${network_info_path}/networkinfo.json /opt/install
cp -rf /opt/install/NCE*_EasySuite/${code}/${network_info_path}/networkinfo_NCE.json /opt/install
cp -rf /opt/install/NCE*_EasySuite/${code}/${network_info_path}/networkinfo_OMP.json /opt/install
cp -rf /opt/install/NCE*_EasySuite/${code}/scripts/*  /opt/install
if [ ! -f /opt/install/product_NCE.json ] || [ ! -f /opt/install/nodes_NCE.json ] || [ ! -f /opt/install/input.json ] || [ ! -f /opt/install/networkinfo.json ] || [ ! -f /opt/install/networkinfo_NCE.json ] || [ ! -f /opt/install/networkinfo_OMP.json ] ;then
    LOG "ERROR" "Prepare install config file failed, product_NCE.json or nodes_NCE.json or networkinfo.json or networkinfo_NCE.json or networkinfo_OMP.json lack"
fi

LOG "INFO" "RunCmd set_volume.sh"
bash -l /opt/install/set_volume.sh ${protection}
if [ $? = 0 ];then
    LOG "INFO" "RunCmd set_volume.sh success"
else
    LOG "ERROR" "RunCmd set_volume.sh failed"
fi

LOG "INFO" "mkdir /etc/ssl/certs"
[ ! -d "/etc/ssl/certs" ] && mkdir -p "/etc/ssl/certs" && chmod 750 "/etc/ssl" && chmod 750 "/etc/ssl/certs" > /dev/null 2>& 1

LOG "INFO" "RunCmd uninstall_nce.sh"
bash -l /opt/install/uninstall_nce.sh ${protection}
if [ $? = 0 ];then
    LOG "INFO" "RunCmd uninstall_nce.sh success"
else
    LOG "ERROR" "RunCmd uninstall_nce.sh failed"
    exit 1
fi

#检查是否有目录占用
LOG "INFO" "Start check /opt/oss"
#检查目录文件列表
su ossadm -c "/opt/*/manager/agent/tools/shscript/uninstall.sh -f" >>${logFile} 2>&1 >>${logFile} 2>&1
ps -ef | grep -E 'admrun|ossadm|dbuser|ossuser|ossrun|secuser|iscript' |grep -v osconfig | grep -vw grep | awk '{print $2}' | xargs kill -9 >>${logFile} 2>&1
yes | rm -rf /opt/oss /opt/cloud /opt/redis /opt/zenith /opt/pub /home/ossadm/.ssh/ /home/admrunuser/.ssh/ >>${logFile} 2>&1
if [ -d /opt/oss ];then
    chown -R ossadm:ossgroup /opt/oss >>${logFile} 2>&1
    LOG "INFO" "Show status: /opt/oss"
    ls -l /opt/oss >>${logFile} 2>&1
fi
