#!/bin/bash
#脚本记录日志
if [ ! -d /var/ICMR ];then
    mkdir -p /var/ICMR
fi
uninstall_logFile="/tmp/uninstall_nce.log"
logFile="/var/ICMR/uninstall_nce.log"
rm ${logFile} > /dev/null 2>& 1
touch ${logFile} > /dev/null 2>& 1
function LOG()
{
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "`date +%Y`-`date +%m`-`date +%d` `date +%H`:`date +%M`:`date +%S`| ${Level} $2">>${logFile}
}

Main()
{

    if [ -f "/opt/oss/manager/agent/tools/shscript/uninstall.sh" ]
    then
        LOG "INFO" "Start to run uninstall.sh."
        su - ossadm -c "cd /opt/oss/manager/agent/tools/shscript && bash uninstall.sh -f >> ${uninstall_logFile}" >>${logFile} 2>&1
        if [ $? -ne 0 ];then
            LOG "INFO" "Failed to run uninstall.sh."
            return 1
        fi
        rm -rf /opt/backup/smp/* >>${logFile} 2>&1
        LOG "INFO" "Finish to run uninstall.sh."
    fi
    # 清理ossuser，sopuser，ossadm，ftpuser用户的历史密码记录
    sed -i '/^ossuser/d' /etc/security/opasswd >>${logFile} 2>&1
    sed -i '/^sopuser/d' /etc/security/opasswd >>${logFile} 2>&1
    sed -i '/^ossadm/d' /etc/security/opasswd >>${logFile} 2>&1
    sed -i '/^ftpuser/d' /etc/security/opasswd >>${logFile} 2>&1
    return 0
}

Main
exit $?
