#!/bin/bash
. ./controller.inc
if [ `echo $0 | grep -c "/"` -gt 0 ];then
    cd ${0%/*}     
fi

################################################################################
# Function    : check_os_ip_route
# Description : check_os_ip_route.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_os_ip_route
{
    echo "ip list is $ip_list." 1>/dev/null
    flag=0
    for ((i=1;i<=8;i++))
        do
            #index=`eval echo '$'$i`
            ip=`echo $ip_list | awk -F ',' '{print $'$i'}' 2>/dev/null`
            echo $ip | egrep -o "(\<([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\>\.){3}\<([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\>" 1>/dev/null
            if [ $? -eq 0 ]
            then
                ifconfig | grep $ip 1>/dev/null
                if [ $? -eq 0 ]
                then
                    print_log "INFO" "Checking ip address ${ip} successfully."
                else
                    print_log "ERROR" "IP address ${ip} verify failed."
                    ((flag=1))
                fi
            fi
        done

    if [ ${flag} -gt 0 ]
    then 
        return 1
    else
        return 0
    fi
}
