#!/bin/bash
# Copyright Huawei Technologies Co., Ltd. 2020-2021. All rights reserved.

check_IP=$1
service_IP=$2
port=$3
protocol=$4
tmp_path=$5

function main()
{
    local src_dir=$(dirname $(readlink -f "$0"))
    [ ! -d "${tmp_path}" ] && mkdir -p "${tmp_path}"
    local test_result="${tmp_path}"/test_"${service_IP}"_"${check_IP}"_"${port}"_"${protocol}".log
    
        
    # check port
    if [ "${protocol}" == "TCP" ]
    then
        echo "test">/dev/tcp/"${check_IP}"/"${port}"
        if [ $? -ne 0 ]
        then
            echo "test" 2>&1 > /dev/tcp/"${check_IP}"/"${port}" | grep "Connection refused"
            if [ $? -eq 0 ]
            then
                echo "Test from ${service_IP} to NE(${check_IP}:${port}) failed!"
                echo "connect_result=1" > "${test_result}"
                exit 1
            else
                echo "${service_IP} network failure!"
                echo "connect_result=2" > "${test_result}"
                exit 2
            fi
        else
            echo "Test from ${service_IP} to NE(${check_IP}:${port}) successfully!"
            echo "connect_result=0" > "${test_result}"
            exit 0
        fi
    elif [ "${protocol}" == "UDP" ]
    then
        exec 7<>/dev/udp/"${check_IP}"/"${port}"
        if [ $? -eq 1 ]
        then
            echo "${service_IP} network failure!"
            echo "connect_result=2" > "${test_result}"
            exit 2
        fi
        echo "test">&7
        timeout 1 cat <&7
        if [ $? -eq 1 ]
        then
            echo "Test from ${service_IP} to NE(${check_IP}:${port}) failed!"
            echo "connect_result=1" > "${test_result}"
            exec 7<&-
            exec 7>&-
            exit 1
        else
            echo "Test from ${service_IP} to NE(${check_IP}:${port}) successfully!"
            echo "connect_result=0" > "${test_result}"
            exec 7<&-
            exec 7>&-
            exit 0
        fi
    fi
}

main $@
exit $?