#!/bin/bash
OSType=""
if [ -f "/etc/SuSE-release" ];then
    OSType="SuSE"
elif [ -f "/etc/euleros-release" -a "`grep EulerOS /etc/euleros-release`" ];then
    OSType="EulerOS"
else
    echo "OS type not supported"
fi
ls /dev/vdb
if [ $? == 0 ];then
    sd=vdb2
    vg_name=vg_sdb
else
    sd=vda3
    vg_name=vg_root
fi
if [ ! -z "${OSType}" ];then
    if [ "${OSType}" = "SuSE" ];then
        pvcreate /dev/vda2
        pvdisplay
        vgextend ${vg_name} /dev/vda2
        vgdisplay
        extendValue=`echo "${1} - 0.5"|bc`
        lvextend -L +${extendValue}G /dev/${vg_name}/lv_opt
        resize2fs /dev/${vg_name}/lv_opt
        lvdisplay /dev/${vg_name}/lv_opt
    else
        pvcreate /dev/${sd}
        pvdisplay
        vgextend ${vg_name} /dev/${sd}
        vgdisplay
        extendValue=`echo "${1} - 0.5"|bc`
        lvextend -L +${extendValue}G /dev/${vg_name}/lv_opt
        resize2fs /dev/${vg_name}/lv_opt
        lvdisplay /dev/${vg_name}/lv_opt
    fi
fi

exit