#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.generate_framework_process.log"
    return 0
}
###############################################################################################
function fn_get_all_log_file_path()
{
    echo "${c_root_path}/cmd.generate_framework_process_all.log"
    return 0
}

###################################################
#
# 参数个数校验
#
###################################################
function fn_check_param_count()
{
    [[ $# != 1 ]] && fn_sys_log_info "Parameter incorrect." && return 1
    return 0
}

###################################################
#
# 判断节点密码是否正确
#
###################################################
function fn_check_ip_passwd()
{
    host_ip="$1"
    fn_sys_log_info "Password verification for [${host_ip}]."
    user="$2"
    fn_run_detect_passwd "${host_ip}" "${user}" "${remote_password}" "ls / >/dev/null 2>&1;" "5" 0
    result=$?
    [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to verify the password." && return 1
    fn_sys_log_info "Password verification succeeded."
    return 0
}

###################################################
#
# 执行远端命令
#
###################################################
function fn_run_command_remote()
{
    fn_sys_log_info "Start executing remote cmds."
    host_ip="$1"
    user="$2"
    passwd="$3"
    command="$4"
    timeout="$5"
    is_log="$6"
    exec_cmd_remote ${host_ip} ${user} "${timeout}" "${command}" ${is_log}<<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && return ${result}
    fn_sys_log_info "Success to execute the remote command." && return 0

}

###################################################
#
# 执行远端命令，测试链接是否可以创建成功
#
###################################################
function fn_run_detect_passwd()
{
    fn_sys_log_info "Start executing remote cmds."
    host_ip="$1"
    user="$2"
    passwd="$3"
    command="$4"
    timeout="$5"
    is_log="$6"
    exec_cmd_remote ${host_ip} ${user} "${timeout}" "${command}" ${is_log}<<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && return ${result}
    fn_sys_log_info "Success to execute the remote command." && return 0

}

###################################################
#
# 清理远端工作空间
#
###################################################
function fn_clean_workspace_flag()
{
    fn_sys_log_info "Start to clean workspace."
    for each_ip in $(cat "${g_upgrade_param}" | grep "${c_host_flag}" | awk -F'=' '{print $NF}' | awk -F"," '{ for(i=1; i<=NF; i++) print $i }'); do
        fn_sys_log_info "Clearing workspace on node [${each_ip}]"
        fn_run_command_remote "${each_ip}" "root" "${remote_password}" "rm -rf ${c_path_workspace} >/dev/null 2>&1;" "5" 1
        result=$?
        [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to clear workspace on node [${each_ip}]." && return 1
        fn_sys_log_info "Success to clear workspace on node [${each_ip}]."
    done
    return 0
}

###################################################
#
# 检查框架拷贝到其他节点
#
###################################################
function fn_cp_frame_remote()
{
    fn_sys_log_info "Copy the framework to all remote nodes."
    for each_ip in $(cat "${g_upgrade_param}" | grep "${c_host_flag}" | awk -F'=' '{print $NF}' | awk -F"," '{ for(i=1; i<=NF; i++) print $i }'); do
        [[ "$(fn_cp_file_remote ${each_ip} "root" "240" ${c_root_path} ${c_path_workspace} ${remote_password})" == "false" ]] && fn_sys_log_error "Failed to copy the framework to the remote node [${each_ip}]." && return 1
    done
    if [[ "x${g_fi_client_ip}" != "x" ]]; then
        fn_sys_log_info "Clearing workspace on fi client node ip ${g_fi_client_ip}"
        fn_run_command_remote "${g_fi_client_ip}" "root" "${remote_password}" "rm -rf ${c_path_workspace} >/dev/null 2>&1;" "5" 1
        fn_sys_log_info "Copy the framework to fi client node ip ${g_fi_client_ip}"
        [[ "$(fn_cp_file_remote ${g_fi_client_ip} "root" "240" ${c_root_path} ${c_path_workspace} ${remote_password})" == "false" ]] && fn_sys_log_error "Failed to copy the framework to the fi client node [${g_fi_client_ip}]." && return 1
    fi
    return 0
}

###################################################
#
# 将检查框架拷贝到其他节点
#
###################################################
function fn_cp_file_remote()
{
    fn_sys_log_info "Copy the detection framework to the remote node."
    host_ip="$1"
    user="$2"
    timeout="$3"
    c_src_path="$4"
    c_path_des="$5"
    passwd="$6"
    cp_file_to_remote "${host_ip}" "${user}" "${timeout}" "${c_src_path}" "${c_path_des}" "0" <<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to copy files to the remote end." && echo "false" && return 1
    fn_sys_log_info "Success to copy files to the remote end." && echo "true" && return 0
}

###################################################
#
# 解析配置参数，获取remote节点.校验节点是否是合法ip
# 判断节点是否可连通，判断节点密码是否正确。
#
###################################################
function fn_check_remote_host()
{
    fn_sys_log_info "Start to get check node."
    for each_ip in $(cat "${g_upgrade_param}" | grep "${c_host_flag}" | awk -F'=' '{print $NF}' | awk -F"," '{ for(i=1; i<=NF; i++) print $i }'); do
        fn_sys_log_info "check_ip is [${each_ip}]"
        [[ "$(fn_sys_is_valid_ip ${each_ip})" == "false" ]] && fn_sys_log_error "Token [${each_ip}] is not a valid ip" && return 1
        fn_sys_log_info "Check ip success."
        [[ "$(fn_ping_ip_ok ${each_ip})" == "false" ]] && fn_sys_log_error "Failed to connect to the remote node ${each_ip}." && return 1
        fn_sys_log_info "Check remote node ping success."
        fn_check_ip_passwd ${each_ip} ${g_remote_user}
        [[ $? -ne 0 ]] && fn_sys_log_error "Failed to log in to the remote node whose IP address is ${each_ip}." && return 1
        fn_sys_log_info "Check remote node password success."
    done
    return 0
}

###############################################################################################
function fn_init()
{
    readonly c_root_path=$(dirname $(readlink -f $0 ))
    source ${c_root_path}/shscript/utils/load_all_util.sh
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    readonly c_log_file="$(fn_get_log_file_path)"

    # save history log file
    readonly all_log_file="$(fn_get_all_log_file_path)"
    fn_sys_create_log_file "$all_log_file"
    [ -f "${c_log_file}" ]  && cat "${c_log_file}" >> ${all_log_file}

    rm -f "${c_log_file}"
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"
    source "${c_root_path}/shscript/profile/${scene_name}_profile.sh"
    return 0
}

###############################################################################################
# 1 执行用户是否是root
# 2 检查参数是否是0个
# 3 判断入参文件是否存在
# 4 检查是否有重复进程已经执行
# 5 检查ip是否是合法IP
# 6 检查远程节点是否可达
###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    fn_check_param_count "$@" || return 1
    fn_sys_assert_in_range "scene_name" "check,upgrade"
    fn_sys_assert_not_null "omp_ip" || return 1
    fn_sys_assert_not_null "g_upgrade_param" || return 1
    fn_sys_assert_is_file "g_upgrade_param" || return 1
    remote_password=""
    [[ ${scene_name} == "upgrade" ]] || fn_init_node_passwd
    [[ "$(fn_sys_is_valid_ip "${omp_ip}")" == "false" ]] && fn_sys_log_error "The OMP IP address in the configuration file is invalid." && return 1

    fn_check_remote_host || return 1
    return 0
}

###############################################################################################

###############################################################################################
function fn_init_node_passwd()
{
    echo -n "Enter the password of the root user: "
    IFS=$'\n'
    read -sr remote_password
    echo -e "\n"
}

###############################################################################################
# 1 清理 所有远端空间/opt/HDSetupTool_tmp里面的检查脚本
# 2 创建 ${root_path}/log 用于存放取回来的日志。
###############################################################################################
function fn_prepare()
{
    fn_sys_log_info "Prepare for pre-installation check."
    fn_clean_workspace_flag || return 1
    mkdir -p "${c_root_path}/log"
    return 0
}

###############################################################################################
function fn_do()
{
    fn_sys_log_info "Start the pre-installation check..."
    fn_cp_frame_remote || return 1

    fn_sys_log_info "Pre-installation check done."
    return 0
}

###############################################################################################
function fn_main()
{

    readonly c_start_time="$(date +%s)"
    scene_name=${1}
    fn_init || return 1
    fn_sys_log_enter
    fn_precheck "$@" || return 1
    fn_prepare || return 1
    fn_do || return 1

    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_leave "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    return "$l_result"
}

###############################################################################################

fn_main "$@"
result="$?"
fn_sys_audit_log "${result}" "Init Check" "Execute remote_launch "
exit "${result}"
