#!/bin/bash

function check_kernel_shmmax()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking KernelShmmax."

    shmmax=$(sysctl -q kernel.shmmax)
    shmmax=$(echo ${shmmax} | awk -F '=' '{print $2}'| sed "s/[[:space:]]//g")

    shmall=$(sysctl -q kernel.shmall)
    shmall=$(echo ${shmall} | awk -F '=' '{print $2}'| sed "s/[[:space:]]//g")

    shmmax_physic=$(free -b | sed -n '2p' | awk '{print $2}')

    shmmax_suggest=$(expr $shmmax_physic / 2)
    if (echo "$shmmax" "$shmmax_suggest" | awk '!($1<$2){exit 1}')
         then
         fn_sys_log_warn "${host_ip}: The kernel shared memory is too small. The recommended Maximum value is ${shmmax_suggest}."
    fi

    page_size=$(getconf PAGESIZE)
    [ -n $page_size -a $page_size -eq 0 ] && fn_sys_log_info "The page size is empty. Skip checking the kernel.shmall in /etc/sysctl." && return 0

    shmall_suggest=$(expr $shmmax_physic / 2 / $page_size)
    if (echo "$shmall" "$shmall_suggest" | awk '!($1<$2){exit 1}')
        then
        fn_sys_log_warn "${host_ip}: The kernel total amount of shared memory pages is too small. The recommended minimum value is ${shmall_suggest}."
    fi
    fn_sys_log_info "${host_ip}: Success checking KernelShmmax."
}
