#!/usr/bin/env bash
readonly g_remote_user="root"
readonly c_host_flag="fi_node_ip"
readonly c_fi_client_flag="fi_client_path"
readonly c_fi_client_ip="fi_client_ip"
readonly c_path_workspace="/opt/NdpTools"
readonly g_upgrade_param="${c_root_path}/conf/fi_upgrade_param.conf"

PYTHONHOME="/opt/insight_upgrade/script/python/"
# Initialization backup path
readonly g_backup_path="/opt/backup/upgrade"
readonly g_backup_srv_facl_path="${g_backup_path}/backup_srv_facl.conf"
readonly g_fi_install_path="/opt/huawei/Bigdata/"
readonly g_migrate_conf="${c_root_path}/conf/fi_upgrade_migrate.json"
readonly g_upgrade_Dir="/export/ossuser/upgrade_dir"
readonly g_upgrade_flag="/export/ossuser/upgrade_dir/upgrade_install.flag"
readonly g_upgrade_checkpoint="/export/ossuser/upgrade_dir/hdfs_checkpoint_flag"
readonly g_upgrade_replace_flag="/export/ossuser/upgrade_dir/upgrade_replace_install.flag"
readonly g_upgrade_cluster_id_file="/tmp/fi_cluster_id.flag"
export g_upgrade_cluster_id_file
if [ -f $g_upgrade_cluster_id_file ]; then
  readonly g_upgrade_cluster_id=$(cat $g_upgrade_cluster_id_file)
  export g_upgrade_cluster_id
fi
readonly g_namenode_copy_flag="/export/ossuser/upgrade_dir/flag_copy_namenode"
readonly g_source_version="meta_data"
readonly g_fi_backup_file="FI_backup_${g_source_version}.tar.gz.upgrade"

# 升级、回滚、确认标志位
readonly g_process_upgrade_flag="/tmp/hd_upgrade_flag"
readonly g_process_rollback_flag="/tmp/hd_rollback_flag"
readonly g_process_confirm_flag="/tmp/hd_confirm_flag"
readonly g_process_kafka_backup_flag="/tmp/hd_backup_kafka_flag"
dos2unix ${g_migrate_conf} > /dev/null 2>&1
dos2unix ${g_upgrade_param} > /dev/null 2>&1
# 升级入参，FI客户端地址。
g_fi_client_path=$(cat "${g_upgrade_param}" | grep ${c_fi_client_flag} | grep -v grep | awk -F '=' '{print $2}' | tr -d '[:space:]')
omp_ip=$(cat "${g_upgrade_param}" | grep ${c_host_flag} | grep -v grep | awk -F '=' '{print $2}' | awk -F ',' '{print $1}' | tr -d '[:space:]')
fi_ip_list=$(cat "${g_upgrade_param}" | grep "${c_host_flag}" | awk -F'=' '{print $NF}' | awk -F"," '{ for(i=1; i<=NF; i++) print $i }')
g_fi_ip_list=$(cat "${g_upgrade_param}" | grep "${c_host_flag}" | cut -d'=' -f2)
export g_fi_ip_list

g_fi_client_ip=$(cat "${g_upgrade_param}" | grep ${c_fi_client_ip} | grep -v grep | awk -F '=' '{print $2}' | tr -d '[:space:]')
readonly tar_kafka_meta_back_file=${g_upgrade_Dir}/Kafka-Metadata.tar.gz
readonly namenode_flag_path="/srv/BigData/namenode/current"
readonly aof_collect_path="/opt/backup/redis_aof"
readonly aof_flag_path="/tmp/bk_redis_aof_flag"
readonly src_tmp_pwd_file="/etc/src_pwd_file"
readonly tar_tmp_pwd_file="/etc/tar_pwd_file"
readonly aof_backup_path="/opt/huawei/Bigdata/backup_aof_redis"
readonly fi_cluster_json="/tmp/ficluster_conf.json"
readonly skip_dir="/srv/BigData/LocalBackup,/srv/BigData/Manager,/srv/BigData/dbdata_om,/srv/BigData/dbdata_service,/srv/BigData/metric_agent"
readonly need_tar_dir="/srv/BigData/journalnode,/srv/BigData/ldapData,/srv/BigData/namenode,/srv/BigData/redis,/srv/BigData/redis_meta,/srv/BigData/tmp,/srv/BigData/zookeeper"
